/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.gremlin.client;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.tinkerpop.gremlin.driver.Result;

public final class CypherResultSet
implements Iterable<Map<String, Object>> {
    private final Iterator<Result> resultIterator;
    private Function<Object, Map<String, Object>> returnNormalizer;

    CypherResultSet(Iterator<Result> resultIterator) {
        this(resultIterator, CypherResultSet::castToMap);
    }

    CypherResultSet(Iterator<Result> resultIterator, Function<Object, Map<String, Object>> returnNormalizer) {
        this.resultIterator = resultIterator;
        this.returnNormalizer = returnNormalizer;
    }

    public List<Map<String, Object>> all() {
        return this.stream().collect(Collectors.toList());
    }

    @Override
    public Spliterator<Map<String, Object>> spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 1280);
    }

    public Stream<Map<String, Object>> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    public Iterator<Map<String, Object>> iterator() {
        return new Iterator<Map<String, Object>>(){

            @Override
            public boolean hasNext() {
                return CypherResultSet.this.resultIterator.hasNext();
            }

            @Override
            public Map<String, Object> next() {
                Result result = (Result)CypherResultSet.this.resultIterator.next();
                Object row = result.getObject();
                return (Map)CypherResultSet.this.returnNormalizer.apply(row);
            }
        };
    }

    private static Map<String, Object> castToMap(Object e) {
        return (Map)e;
    }
}

