/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.gremlin.client;

import java.io.Closeable;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.opencypher.gremlin.client.BytecodeCypherGremlinClient;
import org.opencypher.gremlin.client.CypherResultSet;
import org.opencypher.gremlin.client.CypherStatement;
import org.opencypher.gremlin.client.GroovyCypherGremlinClient;
import org.opencypher.gremlin.client.InMemoryCypherGremlinClient;
import org.opencypher.gremlin.client.OpProcessorCypherGremlinClient;
import org.opencypher.gremlin.client.SyncGroovyCypherGremlinClient;
import org.opencypher.gremlin.translation.groovy.GroovyPredicate;
import org.opencypher.gremlin.translation.translator.Translator;
import org.opencypher.gremlin.translation.translator.TranslatorFlavor;

public interface CypherGremlinClient
extends Closeable {
    public static CypherGremlinClient plugin(Client client) {
        return new OpProcessorCypherGremlinClient(client);
    }

    public static CypherGremlinClient translating(Client client) {
        return CypherGremlinClient.translating(client, TranslatorFlavor.gremlinServer());
    }

    public static CypherGremlinClient translating(Client client, TranslatorFlavor flavor) {
        return CypherGremlinClient.translating(client, () -> Translator.builder().gremlinGroovy().build(flavor));
    }

    public static CypherGremlinClient translating(Client client, Supplier<Translator<String, GroovyPredicate>> translatorSupplier) {
        return new GroovyCypherGremlinClient(client, translatorSupplier);
    }

    public static CypherGremlinClient bytecode(Client client) {
        return CypherGremlinClient.bytecode(client, TranslatorFlavor.gremlinServer());
    }

    public static CypherGremlinClient bytecode(Client client, TranslatorFlavor flavor) {
        return CypherGremlinClient.bytecode(client, () -> Translator.builder().bytecode().build(flavor));
    }

    public static CypherGremlinClient bytecode(Client client, Supplier<Translator<Bytecode, P>> translatorSupplier) {
        return new BytecodeCypherGremlinClient(client, translatorSupplier);
    }

    public static CypherGremlinClient inMemory(GraphTraversalSource gts) {
        return new InMemoryCypherGremlinClient(gts);
    }

    public static CypherGremlinClient retrieving(Client client, TranslatorFlavor flavor) {
        return new SyncGroovyCypherGremlinClient(client, () -> Translator.builder().gremlinGroovy().build(flavor));
    }

    @Override
    public void close();

    default public CypherResultSet submit(String cypher) {
        return this.submitAsync(cypher, Collections.emptyMap()).join();
    }

    default public CypherResultSet submit(String cypher, Map<String, ?> parameters) {
        return this.submitAsync(cypher, parameters).join();
    }

    default public CompletableFuture<CypherResultSet> submitAsync(String cypher) {
        return this.submitAsync(cypher, Collections.emptyMap());
    }

    default public CypherStatement.Submittable statement(String cypher) {
        return new CypherStatement.Submittable(this, cypher, 0L, Collections.emptyMap());
    }

    default public CompletableFuture<CypherResultSet> submitAsync(String cypher, Map<String, ?> parameters) {
        return this.submitAsync(CypherStatement.create(cypher, parameters));
    }

    public CompletableFuture<CypherResultSet> submitAsync(CypherStatement var1);
}

