/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.gremlin.client;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.opencypher.gremlin.client.CypherResultSet;
import org.opencypher.gremlin.translation.CypherAst;
import org.opencypher.gremlin.translation.translator.Translator;

final class CommonResultSets {
    private CommonResultSets() {
    }

    static CypherResultSet explain(CypherAst ast) {
        LinkedHashMap<String, Object> explanation = new LinkedHashMap<String, Object>();
        Translator translator = Translator.builder().gremlinGroovy().inlineParameters().build();
        explanation.put("translation", ast.buildTranslation(translator));
        explanation.put("options", ast.getOptions().toString());
        Iterator<Result> iterator = CommonResultSets.singletonIterator(() -> new Result((Object)explanation));
        return new CypherResultSet(iterator);
    }

    static CypherResultSet exceptional(Throwable throwable) {
        return new CypherResultSet(CommonResultSets.singletonIterator(() -> {
            throw new RuntimeException(throwable);
        }));
    }

    private static <R> Iterator<R> singletonIterator(final Supplier<R> supplier) {
        return new Iterator<R>(){
            private boolean done;

            @Override
            public boolean hasNext() {
                return !this.done;
            }

            @Override
            public R next() {
                if (this.done) {
                    throw new NoSuchElementException();
                }
                this.done = true;
                return supplier.get();
            }
        };
    }
}

