/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.gremlin.client;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.apache.tinkerpop.gremlin.driver.ResultSet;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.opencypher.gremlin.client.CommonResultSets;
import org.opencypher.gremlin.client.CypherGremlinClient;
import org.opencypher.gremlin.client.CypherResultSet;
import org.opencypher.gremlin.client.CypherStatement;
import org.opencypher.gremlin.client.TraverserIterator;
import org.opencypher.gremlin.translation.CypherAst;
import org.opencypher.gremlin.translation.StatementOption;
import org.opencypher.gremlin.translation.translator.Translator;
import org.opencypher.gremlin.traversal.ParameterNormalizer;
import org.opencypher.gremlin.traversal.ReturnNormalizer;

final class BytecodeCypherGremlinClient
implements CypherGremlinClient {
    private final Client client;
    private final Supplier<Translator<Bytecode, P>> translatorSupplier;

    BytecodeCypherGremlinClient(Client client, Supplier<Translator<Bytecode, P>> translatorSupplier) {
        this.client = client;
        this.translatorSupplier = translatorSupplier;
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public CompletableFuture<CypherResultSet> submitAsync(CypherStatement statement) {
        Bytecode bytecode;
        CypherAst ast;
        Map normalizedParameters = ParameterNormalizer.normalize(statement.parameters());
        try {
            ast = CypherAst.parse((String)statement.query(), (Map)normalizedParameters);
        }
        catch (Exception e) {
            return CompletableFuture.completedFuture(CommonResultSets.exceptional(e));
        }
        if (ast.getOptions().contains(StatementOption.EXPLAIN)) {
            return CompletableFuture.completedFuture(CommonResultSets.explain(ast));
        }
        Translator<Bytecode, P> translator = this.translatorSupplier.get();
        try {
            bytecode = (Bytecode)ast.buildTranslation(translator);
        }
        catch (Exception e) {
            return CompletableFuture.completedFuture(CommonResultSets.exceptional(e));
        }
        CompletableFuture resultSetFuture = this.client.submitAsync(bytecode, statement.requestOptions());
        ReturnNormalizer returnNormalizer = ReturnNormalizer.create((Map)ast.getReturnTypes());
        return ((CompletableFuture)resultSetFuture.thenApply(ResultSet::iterator)).thenApply(resultIterator -> new CypherResultSet(new TraverserIterator((Iterator<Result>)resultIterator), arg_0 -> ((ReturnNormalizer)returnNormalizer).normalize(arg_0)));
    }
}

