/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.gremlin.neo4j.driver;

import java.net.URI;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.GraphBinaryMessageSerializerV1;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.neo4j.driver.v1.Driver;
import org.opencypher.gremlin.neo4j.driver.Config;
import org.opencypher.gremlin.neo4j.driver.GremlinGraphDriver;
import org.opencypher.gremlin.neo4j.driver.GremlinServerDriver;

public class GremlinDatabase {
    public static Driver driver(String uri) {
        return GremlinDatabase.driver(uri, Config.defaultConfig());
    }

    public static Driver driver(URI uri) {
        return GremlinDatabase.driver(uri, Config.defaultConfig());
    }

    public static Driver driver(Cluster cluster) {
        return GremlinDatabase.driver(cluster, Config.defaultConfig());
    }

    public static Driver driver(GraphTraversalSource graphTraversalSource) {
        return new GremlinGraphDriver(graphTraversalSource);
    }

    public static Driver driver(String uri, Config config) {
        return GremlinDatabase.driver(URI.create(uri), config);
    }

    public static Driver driver(URI uri, Config config) {
        Cluster cluster = Cluster.build().addContactPoint(uri.getHost()).serializer((MessageSerializer)new GraphBinaryMessageSerializerV1()).port(uri.getPort()).create();
        return new GremlinServerDriver(cluster, config);
    }

    public static Driver driver(Cluster cluster, Config config) {
        return new GremlinServerDriver(cluster, config);
    }
}

