/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.gremlin.neo4j.driver;

import java.util.Iterator;

class PeekingIterator<E>
implements Iterator<E> {
    private final Iterator<E> iterator;
    private E peeked = null;

    PeekingIterator(Iterator<E> iterator) {
        this.iterator = iterator;
    }

    private boolean hasPeeked() {
        return this.peeked != null;
    }

    @Override
    public boolean hasNext() {
        return this.hasPeeked() || this.iterator.hasNext();
    }

    @Override
    public E next() {
        if (!this.hasPeeked()) {
            return this.iterator.next();
        }
        E result = this.peeked;
        this.peeked = null;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Removal from result iterator is not supported");
    }

    public E peek() {
        if (!this.hasPeeked()) {
            this.peeked = this.iterator.next();
        }
        return this.peeked;
    }
}

