/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.gremlin.neo4j.driver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.exceptions.NoSuchRecordException;
import org.neo4j.driver.v1.summary.ResultSummary;
import org.neo4j.driver.v1.summary.ServerInfo;
import org.neo4j.driver.v1.util.Function;
import org.opencypher.gremlin.neo4j.driver.GremlinCypherValueConverter;
import org.opencypher.gremlin.neo4j.driver.GremlinServerResultSummary;
import org.opencypher.gremlin.neo4j.driver.PeekingIterator;

class GremlinServerStatementResult
implements StatementResult {
    private final PeekingIterator<Map<String, Object>> iterator;
    private final ServerInfo serverInfo;
    private final Statement statement;
    private final GremlinCypherValueConverter converter;

    GremlinServerStatementResult(ServerInfo serverInfo, Statement statement, Iterator<Map<String, Object>> iterator, GremlinCypherValueConverter converter) {
        this.iterator = new PeekingIterator<Map<String, Object>>(iterator);
        this.serverInfo = serverInfo;
        this.statement = statement;
        this.converter = converter;
    }

    public List<String> keys() {
        return this.peek().keys();
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public Record next() {
        return this.converter.toRecord(this.iterator.next());
    }

    public Record single() throws NoSuchRecordException {
        if (!this.iterator.hasNext()) {
            throw new NoSuchRecordException("Cannot retrieve a single record, because this result is empty.");
        }
        Record next = this.next();
        if (this.iterator.hasNext()) {
            throw new NoSuchRecordException("Expected a result with a single record, but this result contains at least one more. Ensure your query returns only one record, or use `first` instead of `single` if you do not care about the number of records in the result.");
        }
        return next;
    }

    public Record peek() {
        return this.converter.toRecord(this.iterator.peek());
    }

    public List<Record> list() {
        ArrayList<Record> list = new ArrayList<Record>();
        this.iterator.forEachRemaining(e -> list.add(this.converter.toRecord((Map<String, Object>)e)));
        return list;
    }

    public <T> List<T> list(Function<Record, T> mapFunction) {
        return this.list().stream().map(arg_0 -> mapFunction.apply(arg_0)).collect(Collectors.toList());
    }

    public ResultSummary consume() {
        this.list();
        return new GremlinServerResultSummary(this.statement, this.serverInfo);
    }

    public ResultSummary summary() {
        return new GremlinServerResultSummary(this.statement, this.serverInfo);
    }
}

