/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.gremlin.traversal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.opencypher.gremlin.translation.exception.ConstraintException;
import org.opencypher.gremlin.translation.exception.CypherExceptions;
import org.opencypher.gremlin.translation.exception.TypeException;

public final class CustomFunctions {
    private CustomFunctions() {
    }

    public static Function<Traverser, Object> cypherToString() {
        return traverser -> {
            boolean valid;
            Object arg = CustomFunctions.tokenToNull(traverser.get());
            boolean bl = valid = arg == null || arg instanceof Boolean || arg instanceof Number || arg instanceof String;
            if (!valid) {
                String className = arg.getClass().getName();
                throw new TypeException("Cannot convert " + className + " to string");
            }
            return Optional.ofNullable(arg).map(String::valueOf).orElse("  cypher.null");
        };
    }

    public static Function<Traverser, Object> cypherToBoolean() {
        return traverser -> {
            boolean valid;
            Object arg = CustomFunctions.tokenToNull(traverser.get());
            boolean bl = valid = arg == null || arg instanceof Boolean || arg instanceof String;
            if (!valid) {
                String className = arg.getClass().getName();
                throw new TypeException("Cannot convert " + className + " to boolean");
            }
            return Optional.ofNullable(arg).map(String::valueOf).map(v -> {
                switch (v.toLowerCase()) {
                    case "true": {
                        return Boolean.valueOf(true);
                    }
                    case "false": {
                        return Boolean.valueOf(false);
                    }
                }
                return "  cypher.null";
            }).orElse((Serializable)((Object)"  cypher.null"));
        };
    }

    public static Function<Traverser, Object> cypherToInteger() {
        return traverser -> {
            boolean valid;
            Object arg = CustomFunctions.tokenToNull(traverser.get());
            boolean bl = valid = arg == null || arg instanceof Number || arg instanceof String;
            if (!valid) {
                String className = arg.getClass().getName();
                throw new TypeException("Cannot convert " + className + " to integer");
            }
            return CustomFunctions.nullToToken(Optional.ofNullable(arg).map(String::valueOf).map(v -> {
                try {
                    return Long.valueOf(v);
                }
                catch (NumberFormatException e1) {
                    try {
                        return Double.valueOf(v).longValue();
                    }
                    catch (NumberFormatException e2) {
                        return null;
                    }
                }
            }).orElse(null));
        };
    }

    public static Function<Traverser, Object> cypherToFloat() {
        return traverser -> {
            boolean valid;
            Object arg = CustomFunctions.tokenToNull(traverser.get());
            boolean bl = valid = arg == null || arg instanceof Number || arg instanceof String;
            if (!valid) {
                String className = arg.getClass().getName();
                throw new TypeException("Cannot convert " + className + " to float");
            }
            return CustomFunctions.nullToToken(Optional.ofNullable(arg).map(String::valueOf).map(v -> {
                try {
                    return Double.valueOf(v);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }).orElse(null));
        };
    }

    public static Function<Traverser, Object> cypherRound() {
        return CustomFunctions.cypherFunction(a -> Math.round((Double)a.get(0)), Double.class);
    }

    public static Function<Traverser, Object> cypherProperties() {
        return traverser -> {
            Object argument = traverser.get();
            if (argument == "  cypher.null") {
                return "  cypher.null";
            }
            if (argument instanceof Map) {
                return argument;
            }
            Iterator it = ((Element)argument).properties(new String[0]);
            HashMap<String, Object> propertyMap = new HashMap<String, Object>();
            while (it.hasNext()) {
                Property property = (Property)it.next();
                propertyMap.putIfAbsent(property.key(), property.value());
            }
            return propertyMap;
        };
    }

    public static Function<Traverser, Object> cypherContainerIndex() {
        return traverser -> {
            List args = (List)traverser.get();
            Object container = args.get(0);
            Object index = args.get(1);
            if (container == "  cypher.null" || index == "  cypher.null") {
                return "  cypher.null";
            }
            if (container instanceof List) {
                List list = (List)container;
                int size = list.size();
                int i = CustomFunctions.normalizeContainerIndex(index, size);
                if (i < 0 || i > size) {
                    return "  cypher.null";
                }
                return list.get(i);
            }
            if (container instanceof Map) {
                if (!(index instanceof String)) {
                    String indexClass = index.getClass().getName();
                    throw new IllegalArgumentException("Map element access by non-string: " + indexClass);
                }
                Map map = (Map)container;
                String key = (String)index;
                return map.getOrDefault(key, "  cypher.null");
            }
            if (container instanceof Element) {
                if (!(index instanceof String)) {
                    String indexClass = index.getClass().getName();
                    throw new IllegalArgumentException("Property access by non-string: " + indexClass);
                }
                Element element = (Element)container;
                String key = (String)index;
                return element.property(key).orElse((Object)"  cypher.null");
            }
            String containerClass = container.getClass().getName();
            if (index instanceof String) {
                throw new IllegalArgumentException("Invalid property access of " + containerClass);
            }
            throw new IllegalArgumentException("Invalid element access of " + containerClass);
        };
    }

    public static Function<Traverser, Object> cypherListSlice() {
        return traverser -> {
            List args = (List)traverser.get();
            Object container = args.get(0);
            Object from = args.get(1);
            Object to = args.get(2);
            if (container == "  cypher.null") {
                return "  cypher.null";
            }
            if (container instanceof List) {
                int t;
                List list = (List)container;
                int size = list.size();
                int f = CustomFunctions.normalizeRangeIndex(from, size);
                if (f >= (t = CustomFunctions.normalizeRangeIndex(to, size))) {
                    return new ArrayList();
                }
                return new ArrayList(list.subList(f, t));
            }
            String containerClass = container.getClass().getName();
            throw new IllegalArgumentException("Invalid element access of " + containerClass + " by range");
        };
    }

    private static int normalizeContainerIndex(Object index, int containerSize) {
        if (!(index instanceof Number)) {
            String indexClass = index.getClass().getName();
            throw new IllegalArgumentException("List element access by non-integer: " + indexClass);
        }
        int i = ((Number)index).intValue();
        return i >= 0 ? i : containerSize + i;
    }

    private static int normalizeRangeIndex(Object index, int size) {
        int i = CustomFunctions.normalizeContainerIndex(index, size);
        if (i < 0) {
            return 0;
        }
        if (i > size) {
            return size;
        }
        return i;
    }

    public static Function<Traverser, Object> cypherPercentileCont() {
        return CustomFunctions.percentileFunction((data, percentile) -> {
            double highPercentile;
            int last = data.size() - 1;
            double lowPercentile = Math.floor(percentile * (double)last) / (double)last;
            if (lowPercentile == (highPercentile = Math.ceil(percentile * (double)last) / (double)last)) {
                return (Number)CustomFunctions.percentileNearest(data, percentile);
            }
            double scale = (percentile - lowPercentile) / (highPercentile - lowPercentile);
            double low = ((Number)CustomFunctions.percentileNearest(data, lowPercentile)).doubleValue();
            double high = ((Number)CustomFunctions.percentileNearest(data, highPercentile)).doubleValue();
            return (high - low) * scale + low;
        });
    }

    public static Function<Traverser, Object> cypherPercentileDisc() {
        return CustomFunctions.percentileFunction(CustomFunctions::percentileNearest);
    }

    private static Function<Traverser, Object> percentileFunction(BiFunction<List<Number>, Double, Number> percentileStrategy) {
        return traverser -> {
            List args = (List)traverser.get();
            double percentile = ((Number)args.get(1)).doubleValue();
            if (percentile < 0.0 || percentile > 1.0) {
                throw new IllegalArgumentException("Number out of range: " + percentile);
            }
            Collection coll = (Collection)args.get(0);
            boolean invalid = coll.stream().anyMatch(o -> o != null && !(o instanceof Number));
            if (invalid) {
                throw new IllegalArgumentException("Percentile function can only handle numerical values");
            }
            List data = coll.stream().filter(Objects::nonNull).map(o -> (Number)o).sorted().collect(Collectors.toList());
            int size = data.size();
            if (size == 0) {
                return "  cypher.null";
            }
            if (size == 1) {
                return data.get(0);
            }
            return percentileStrategy.apply(data, percentile);
        };
    }

    private static <T> T percentileNearest(List<T> sorted, double percentile) {
        int size = sorted.size();
        int index = (int)Math.ceil(percentile * (double)size) - 1;
        if (index == -1) {
            index = 0;
        }
        return sorted.get(index);
    }

    public static Function<Traverser, Object> cypherSize() {
        return traverser -> traverser.get() instanceof String ? (long)((String)traverser.get()).length() : (long)((Collection)traverser.get()).size();
    }

    public static Function<Traverser, Object> cypherPlus() {
        return traverser -> {
            List args = (List)traverser.get();
            Object a = args.get(0);
            Object b = args.get(1);
            if (a == "  cypher.null" || b == "  cypher.null") {
                return "  cypher.null";
            }
            if (a instanceof List || b instanceof List) {
                ArrayList objects = new ArrayList();
                if (a instanceof List) {
                    objects.addAll((List)a);
                } else {
                    objects.add(a);
                }
                if (b instanceof List) {
                    objects.addAll((List)b);
                } else {
                    objects.add(b);
                }
                return objects;
            }
            if (!(a instanceof String) && !(a instanceof Number) || !(b instanceof String) && !(b instanceof Number)) {
                throw new TypeException("Illegal use of plus operator");
            }
            if (a instanceof Number && b instanceof Number) {
                if (a instanceof Double || b instanceof Double || a instanceof Float || b instanceof Float) {
                    return ((Number)a).doubleValue() + ((Number)b).doubleValue();
                }
                return ((Number)a).longValue() + ((Number)b).longValue();
            }
            return String.valueOf(a) + String.valueOf(b);
        };
    }

    public static Function<Traverser, Object> cypherReverse() {
        return traverser -> {
            Object o = traverser.get();
            if (o == "  cypher.null") {
                return "  cypher.null";
            }
            if (o instanceof Collection) {
                ArrayList result = new ArrayList((Collection)o);
                Collections.reverse(result);
                return result;
            }
            if (o instanceof String) {
                return new StringBuilder((String)o).reverse().toString();
            }
            throw new TypeException(String.format("Expected a string or list value for reverse, but got: %s(%s)", o.getClass().getSimpleName(), o));
        };
    }

    public static Function<Traverser, Object> cypherSubstring() {
        return traverser -> {
            List args = (List)traverser.get();
            Object a = args.get(0);
            Object b = args.get(1);
            if (a == "  cypher.null") {
                return "  cypher.null";
            }
            if (!(a instanceof String) || !(b instanceof Number)) {
                throw new TypeException(String.format("Expected substring(String, Integer, [Integer]), but got: (%s, %s)", a, b));
            }
            if (args.size() == 3 && !(args.get(2) instanceof Number)) {
                throw new TypeException(String.format("Expected substring(String, Integer, [Integer]), but got: (%s, %s, %s)", a, b, args.get(2)));
            }
            if (args.size() == 3) {
                String s = (String)a;
                int endIndex = ((Number)b).intValue() + ((Number)args.get(2)).intValue();
                endIndex = endIndex > s.length() ? s.length() : endIndex;
                return s.substring(((Number)b).intValue(), endIndex);
            }
            return ((String)a).substring(((Number)b).intValue());
        };
    }

    private static Function<Traverser, Object> cypherFunction(Function<List, Object> func, Class<?> ... clazzes) {
        return traverser -> {
            List<Object> args = traverser.get() instanceof List ? (List<Object>)traverser.get() : Arrays.asList(traverser.get());
            for (int i = 0; i < clazzes.length; ++i) {
                if (args.get(i) == "  cypher.null") {
                    return "  cypher.null";
                }
                if (clazzes[i].isInstance(args.get(i))) continue;
                throw new TypeException(String.format("Expected a %s value for <function1>, but got: %s(%s)", clazzes[i].getSimpleName(), args.get(i).getClass().getSimpleName(), args.get(i)));
            }
            return func.apply(args);
        };
    }

    public static Function<Traverser, Object> cypherTrim() {
        return CustomFunctions.cypherFunction(a -> ((String)a.get(0)).trim(), String.class);
    }

    public static Function<Traverser, Object> cypherToUpper() {
        return CustomFunctions.cypherFunction(a -> ((String)a.get(0)).toUpperCase(), String.class);
    }

    public static Function<Traverser, Object> cypherToLower() {
        return CustomFunctions.cypherFunction(a -> ((String)a.get(0)).toLowerCase(), String.class);
    }

    public static Function<Traverser, Object> cypherSplit() {
        return CustomFunctions.cypherFunction(a -> Arrays.asList(((String)a.get(0)).split((String)a.get(1))), String.class, String.class);
    }

    public static Function<Traverser, Object> cypherCopyProperties() {
        return traverser -> {
            List args = CustomFunctions.cast(traverser.get(), List.class);
            if (args.get(0) == "  cypher.null") {
                return "  cypher.null";
            }
            Element to = CustomFunctions.cast(args.get(0), Element.class);
            Element from = CustomFunctions.cast(args.get(1), Element.class);
            from.properties(new String[0]).forEachRemaining(prop -> to.property(prop.key(), prop.value()));
            return to;
        };
    }

    public static Function<Traverser, Object> cypherException() {
        return traverser -> {
            String message = CypherExceptions.messageByName(traverser.get());
            throw new ConstraintException(message);
        };
    }

    private static Object tokenToNull(Object maybeNull) {
        return "  cypher.null".equals(maybeNull) ? null : maybeNull;
    }

    private static Object nullToToken(Object maybeNull) {
        return maybeNull == null ? "  cypher.null" : maybeNull;
    }

    private static <T> T cast(Object o, Class<T> clazz) {
        if (clazz.isInstance(o)) {
            return clazz.cast(o);
        }
        throw new TypeException(String.format("Expected %s to be %s, but it was %s", o, clazz.getSimpleName(), o.getClass().getSimpleName()));
    }
}

