/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.grammar;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.xml.stream.XMLStreamException;
import org.opencypher.grammar.Alternatives;
import org.opencypher.grammar.CharacterSet;
import org.opencypher.grammar.Grammar;
import org.opencypher.grammar.Literal;
import org.opencypher.grammar.NonTerminal;
import org.opencypher.grammar.Optional;
import org.opencypher.grammar.Production;
import org.opencypher.grammar.Repetition;
import org.opencypher.grammar.Sequence;
import org.opencypher.grammar.TermTransformation;
import org.opencypher.grammar.TermVisitor;
import org.opencypher.railroad.Diagram;
import org.opencypher.railroad.SVGShapes;
import org.opencypher.railroad.ShapeRenderer;
import org.opencypher.tools.Option;
import org.opencypher.tools.grammar.ISO14977;
import org.opencypher.tools.grammar.RailRoadDiagrams;
import org.opencypher.tools.grammar.Tool;
import org.opencypher.tools.io.HtmlTag;
import org.opencypher.tools.io.Output;

public final class RailRoadDiagramPages
extends Tool
implements ShapeRenderer.Linker,
ISO14977.HtmlLinker {
    private final Diagram.BuilderOptions options = this.options(Diagram.BuilderOptions.class, new Option[0]);
    private static final TermTransformation<Void, Production, RuntimeException> SIMPLE_DEFINITION = new TermTransformation<Void, Production, RuntimeException>(){

        @Override
        public Production transformNonTerminal(Void param, NonTerminal nonTerminal) throws RuntimeException {
            return nonTerminal.production();
        }

        @Override
        public Production transformOptional(Void param, Optional optional) throws RuntimeException {
            return optional.term().transform(this, param);
        }

        @Override
        public Production transformRepetition(Void param, Repetition repetition) throws RuntimeException {
            return repetition.term().transform(this, param);
        }

        @Override
        public Production transformAlternatives(Void param, Alternatives alternatives) throws RuntimeException {
            return null;
        }

        @Override
        public Production transformSequence(Void param, Sequence sequence) throws RuntimeException {
            return null;
        }

        @Override
        public Production transformLiteral(Void param, Literal literal) throws RuntimeException {
            return null;
        }

        @Override
        public Production transformEpsilon(Void param) throws RuntimeException {
            return null;
        }

        @Override
        public Production transformCharacters(Void param, CharacterSet characters) throws RuntimeException {
            return null;
        }
    };

    public static void main(String ... args) throws Exception {
        RailRoadDiagramPages.main(RailRoadDiagramPages::new, RailRoadDiagramPages::generate, args);
    }

    private RailRoadDiagramPages(Map<?, ?> properties) {
        super(properties);
    }

    private void generate(Grammar grammar, Output output) throws IOException, XMLStreamException {
        Path outputDir = this.outputDir();
        ShapeRenderer renderer = RailRoadDiagrams.renderer(this);
        Diagram.CanvasProvider<SVGShapes, XMLStreamException> canvas = RailRoadDiagrams.canvas(output, outputDir);
        int diagrams = 0;
        for (Diagram diagram : Diagram.build(grammar, this.options)) {
            grammar.transform(diagram.name(), (param, production) -> {
                this.writeHtml((Path)param, production);
                return null;
            }, outputDir);
            diagram.render(renderer, canvas);
            ++diagrams;
        }
        output.append("Rendered ").append(diagrams).println(" diagrams.");
    }

    @Override
    public String referenceLink(NonTerminal reference) {
        if (reference.inline()) {
            return "#" + reference.productionName();
        }
        Production production = reference.production();
        while (this.options.shouldSkip(production)) {
            production = production.transform(SIMPLE_DEFINITION, null);
        }
        return production == null ? null : this.referenceLink(production.name());
    }

    @Override
    public String referenceLink(String reference) {
        return reference + ".html";
    }

    @Override
    public String charsetLink(String charset) {
        return RailRoadDiagrams.unicodesetLink(charset);
    }

    private void writeHtml(Path dir, Production production) {
        block49: {
            String svg = production.name() + ".svg";
            try (HtmlTag.Html html = HtmlTag.html(dir.resolve(production.name() + ".html"));){
                html.head(title -> production.name(), HtmlTag.meta("charset", "UTF-8"));
                try (final HtmlTag body = html.body();){
                    body.tag("h1", new HtmlTag.Attribute[0]).text(production.name()).close();
                    body.tag("object", data -> svg, type -> "image/svg+xml").close();
                    String description = production.description();
                    if (description != null) {
                        body.p();
                        body.text(description);
                    }
                    body.tag("h2", new HtmlTag.Attribute[0]).text("EBNF").close();
                    for (NonTerminal nonTerminal : production.references()) {
                        Production site = nonTerminal.declaringProduction();
                        if (!site.skip()) continue;
                        ISO14977.html(body, site, this);
                    }
                    ISO14977.html(body, production, this);
                    production.definition().accept(new InlinedProductions(){

                        @Override
                        void inline(Production production) {
                            body.tag("a", name -> production.name()).close();
                            ISO14977.html(body, production, RailRoadDiagramPages.this);
                        }
                    });
                    Collection<Production> references = production.referencedFrom();
                    if (references.isEmpty()) break block49;
                    body.tag("h2", new HtmlTag.Attribute[0]).text("Referenced from").close();
                    try (HtmlTag ul = body.tag("ul", new HtmlTag.Attribute[0]);){
                        for (Production reference : references) {
                            HtmlTag li = ul.tag("li", new HtmlTag.Attribute[0]);
                            Throwable throwable = null;
                            try {
                                String name = reference.name();
                                li.tag("a", href -> this.referenceLink(name)).text(name).close();
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (li == null) continue;
                                if (throwable != null) {
                                    try {
                                        li.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                li.close();
                            }
                        }
                    }
                }
            }
        }
    }

    private static abstract class InlinedProductions
    implements TermVisitor<RuntimeException>,
    Consumer<Grammar.Term> {
        private final Set<String> inlined = new HashSet<String>();

        private InlinedProductions() {
        }

        abstract void inline(Production var1);

        @Override
        public void accept(Grammar.Term term) {
            term.accept(this);
        }

        @Override
        public void visitNonTerminal(NonTerminal nonTerminal) {
            if (nonTerminal.inline() && this.inlined.add(nonTerminal.productionName())) {
                this.inline(nonTerminal.production());
                nonTerminal.productionDefinition().accept(this);
            }
        }

        @Override
        public void visitAlternatives(Alternatives alternatives) {
            alternatives.forEach(this);
        }

        @Override
        public void visitSequence(Sequence sequence) {
            sequence.forEach(this);
        }

        @Override
        public void visitOptional(Optional optional) {
            optional.term().accept(this);
        }

        @Override
        public void visitRepetition(Repetition repetition) {
            repetition.term().accept(this);
        }

        @Override
        public void visitLiteral(Literal literal) {
        }

        @Override
        public void visitEpsilon() {
        }

        @Override
        public void visitCharacters(CharacterSet characters) {
        }
    }
}

