/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.grammar;

import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import javax.xml.parsers.ParserConfigurationException;
import org.opencypher.generator.Choices;
import org.opencypher.generator.Generator;
import org.opencypher.generator.GeneratorFactory;
import org.opencypher.generator.InteractiveChoices;
import org.opencypher.generator.Node;
import org.opencypher.generator.ProductionReplacement;
import org.opencypher.generator.TracingChoices;
import org.opencypher.grammar.Grammar;
import org.opencypher.tools.grammar.Main;
import org.opencypher.tools.io.LineInput;
import org.opencypher.tools.io.Output;
import org.xml.sax.SAXException;

public class CypherGeneratorFactory
extends GeneratorFactory<State>
implements Supplier<Generator> {
    public static final Supplier<Generator> INSTANCE = new CypherGeneratorFactory();

    @Override
    public Generator get() {
        try {
            return this.generatorResource("/cypher.xml", new Grammar.ParserOption[0]);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new IllegalStateException("Failed to parse Cypher grammar.", e);
        }
    }

    public static void main(String ... args) throws Exception {
        Main.execute((grammar, out) -> {
            Output.Readable output = Output.stringBuilder();
            new CypherGeneratorFactory(){

                @Override
                protected Choices choices() {
                    switch (System.getProperty("choices", "default")) {
                        case "interactive": {
                            return new InteractiveChoices(LineInput.stdIn(), Output.stdOut(), null);
                        }
                        case "tracing": {
                            return new TracingChoices(Output.stdOut(), super.choices());
                        }
                    }
                    return super.choices();
                }
            }.generator(grammar).generate(output);
            Output.output(out).println().append(output).println();
        }, args);
    }

    @Override
    protected State newContext() {
        return new State();
    }

    @GeneratorFactory.Replacement
    public void Variable(ProductionReplacement.Context<State> context) {
        Node parent = context.node().parent();
        switch (parent.name()) {
            case "ReturnItem": {
                context.generateDefault();
                break;
            }
            case "UniqueConstraintSyntax": 
            case "NodePropertyExistenceConstraintSyntax": 
            case "RelationshipPatternSyntax": 
            case "PatternPart": 
            case "IdInCol": 
            case "Reduce": 
            case "StartPoint": 
            case "LoadCSV": 
            case "Unwind": 
            case "Foreach": {
                context.generateDefault();
                break;
            }
            case "RelationshipDetail": 
            case "NodePattern": {
                context.generateDefault();
                break;
            }
            case "Hint": 
            case "SetItem": 
            case "RemoveItem": 
            case "Expression1": {
                context.generateDefault();
                break;
            }
            case "Pragma": {
                context.generateDefault();
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot generate variable in " + parent.name());
            }
        }
    }

    @GeneratorFactory.Replacement
    public void LabelName(ProductionReplacement.Context<State> context) {
        context.generateDefault();
    }

    @GeneratorFactory.Replacement
    public void RelTypeName(ProductionReplacement.Context<State> context) {
        context.generateDefault();
    }

    @GeneratorFactory.Replacement
    public void FunctionName(ProductionReplacement.Context<State> context) {
        context.generateDefault();
    }

    @GeneratorFactory.Replacement
    public void PropertyKeyName(ProductionReplacement.Context<State> context) {
        context.generateDefault();
    }

    @GeneratorFactory.Replacement
    public void IdentifierStart(ProductionReplacement.Context<State> context) {
        context.write(CypherGeneratorFactory.randomCodePoint(Character::isJavaIdentifierStart));
    }

    @GeneratorFactory.Replacement
    public void IdentifierPart(ProductionReplacement.Context<State> context) {
        context.write(CypherGeneratorFactory.randomCodePoint(Character::isJavaIdentifierPart));
    }

    static int randomCodePoint(IntPredicate filter) {
        int cp;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        while (!filter.test(cp = random.nextInt(0, 0x10FFFF))) {
        }
        return cp;
    }

    static class State {
        State() {
        }
    }
}

