/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opencypher.tools.TypedArgument;

public class Reflection {
    private static final MethodHandles.Lookup LOOKUP;

    public static String lambdaParameterName(Serializable lambda) {
        int bound;
        SerializedLambda serialized = Reflection.serializedLambda(lambda);
        Object[] parameters = Reflection.lambdaMethod(serialized).getParameters();
        switch (serialized.getImplMethodKind()) {
            case 6: {
                bound = serialized.getCapturedArgCount();
                break;
            }
            case 7: {
                bound = serialized.getCapturedArgCount() - 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported method kind: " + serialized.getImplMethodKind());
            }
        }
        if (parameters == null || parameters.length - bound != 1) {
            throw new IllegalArgumentException("Must have exactly one parameter, not " + (parameters == null ? 0 : parameters.length) + "; " + Arrays.toString(parameters) + ", bound: " + bound);
        }
        Parameter parameter = parameters[bound];
        if (!parameter.isNamePresent()) {
            throw new IllegalStateException("No parameter name present, compile with '-parameters', and use JDK 1.8.0_60 or newer. Your JDK version is " + System.getProperty("java.version"));
        }
        return parameter.getName();
    }

    private static Method lambdaMethod(SerializedLambda serialized) {
        Class<?> implClass = Reflection.lambdaClass(serialized);
        return Stream.of(implClass.getDeclaredMethods()).filter(method -> Objects.equals(method.getName(), serialized.getImplMethodName())).reduce((l, r) -> {
            throw new IllegalArgumentException("Too many implementation methods.");
        }).orElseThrow(() -> new IllegalStateException("Unable to find implementation method."));
    }

    public static <T> T lambda(MethodHandles.Lookup caller, Class<T> type, MethodHandle target, TypedArgument ... arguments) {
        CallSite site;
        Method sam = Reflection.sam(type);
        Class<?>[] samParameters = sam.getParameterTypes();
        ArrayList targetParameters = new ArrayList(samParameters.length + arguments.length);
        Class<?>[] argParameters = TypedArgument.types(arguments);
        Collections.addAll(targetParameters, argParameters);
        Collections.addAll(targetParameters, samParameters);
        try {
            site = LambdaMetafactory.metafactory(caller, sam.getName(), MethodType.methodType(type, argParameters), MethodType.methodType(sam.getReturnType(), samParameters), target, MethodType.methodType(sam.getReturnType(), targetParameters));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Cannot create lambda for %s.%s(%s)%s from method (%s)%s [actual signature: %s] by invoking (%s)%s", type.getSimpleName(), sam.getName(), Stream.of(samParameters).map(Class::getSimpleName).collect(Collectors.joining(",")), sam.getReturnType().getSimpleName(), targetParameters.stream().map(Class::getSimpleName).collect(Collectors.joining(",")), sam.getReturnType().getSimpleName(), target.type(), Stream.of(argParameters).map(Class::getSimpleName).collect(Collectors.joining(",")), type.getSimpleName()), e);
        }
        try {
            return type.cast(site.dynamicInvoker().invokeWithArguments(TypedArgument.values(arguments)));
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failure when creating lambda.", e);
        }
    }

    public static MethodHandle defaultInvoker(Method method) {
        if (!method.isDefault()) {
            throw new IllegalArgumentException("Not a default method: " + method);
        }
        try {
            return LOOKUP.unreflectSpecial(method, method.getDeclaringClass());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Reflection failed.", e);
        }
    }

    public static Object invoke(MethodHandle method, Object target) {
        try {
            return method.invokeWithArguments(target);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static Method sam(Class<?> type) {
        if (!type.isInterface()) {
            throw new IllegalArgumentException("Not an interface: " + type.getName());
        }
        return Stream.of(type.getMethods()).filter(m -> !m.isDefault() && !Modifier.isStatic(m.getModifiers())).reduce((l, r) -> {
            throw new IllegalStateException("Too many methods.");
        }).orElseThrow(() -> new IllegalStateException("No methods."));
    }

    public static Class<?> lambdaClass(Serializable lambda) {
        return Reflection.lambdaClass(Reflection.serializedLambda(lambda));
    }

    public static String pathOf(Class<?> cls) {
        return cls.getProtectionDomain().getCodeSource().getLocation().getPath();
    }

    public static String lambdaImplMethodName(Serializable lambda) {
        return Reflection.serializedLambda(lambda).getImplMethodName();
    }

    public static MethodHandle methodHandle(MethodHandles.Lookup lookup, Serializable lambda) {
        try {
            SerializedLambda serialized = Reflection.serializedLambda(lambda);
            Class<?> impl = Reflection.lambdaClass(serialized);
            switch (serialized.getImplMethodKind()) {
                case 6: {
                    return lookup.findStatic(impl, serialized.getImplMethodName(), MethodType.fromMethodDescriptorString(serialized.getImplMethodSignature(), impl.getClassLoader()));
                }
                case 5: {
                    return lookup.findVirtual(impl, serialized.getImplMethodName(), MethodType.fromMethodDescriptorString(serialized.getImplMethodSignature(), impl.getClassLoader()));
                }
            }
            throw new UnsupportedOperationException("only static and virtual methods supported");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static SerializedLambda serializedLambda(Serializable lambda) {
        try {
            Method replaceMethod = lambda.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            replaceMethod.setAccessible(true);
            return (SerializedLambda)replaceMethod.invoke((Object)lambda, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Reflection failed.");
        }
    }

    private static Class<?> lambdaClass(SerializedLambda serialized) {
        try {
            return Class.forName(serialized.getImplClass().replaceAll("/", "."));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> Method implementation(T instance, Class<T> base, String methodName) {
        Method proto = Stream.of(base.getDeclaredMethods()).filter(method -> methodName.equals(method.getName()) && Modifier.isAbstract(method.getModifiers())).reduce((l, r) -> {
            throw new IllegalStateException("Too many methods '" + methodName + "' of " + base);
        }).orElseThrow(() -> new IllegalStateException("No method '" + methodName + "' of " + base));
        for (Class<?> klass = instance.getClass(); klass != Object.class; klass = klass.getSuperclass()) {
            Method actual;
            try {
                actual = klass.getDeclaredMethod(proto.getName(), proto.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            if (actual.isBridge()) {
                return Stream.of(klass.getDeclaredMethods()).filter(method -> !method.isBridge() && methodName.equals(method.getName()) && method.getParameterCount() == proto.getParameterCount()).reduce((l, r) -> {
                    throw new IllegalStateException("Too many methods for bridge: " + actual);
                }).orElseThrow(() -> new IllegalStateException("No method for bridge: " + actual));
            }
            return actual;
        }
        throw new IllegalStateException("Cannot find implementation of " + proto);
    }

    static {
        try {
            Field field = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            field.setAccessible(true);
            LOOKUP = (MethodHandles.Lookup)field.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Failed to access default methods.");
        }
    }
}

