/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.grammar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opencypher.grammar.AlternativesNode;
import org.opencypher.grammar.CharacterSetNode;
import org.opencypher.grammar.Description;
import org.opencypher.grammar.LiteralNode;
import org.opencypher.grammar.Located;
import org.opencypher.grammar.Node;
import org.opencypher.grammar.NonTerminal;
import org.opencypher.grammar.NonTerminalNode;
import org.opencypher.grammar.OptionalNode;
import org.opencypher.grammar.Production;
import org.opencypher.grammar.ProductionResolver;
import org.opencypher.grammar.ProductionTransformation;
import org.opencypher.grammar.ProductionVisitor;
import org.opencypher.grammar.RepetitionNode;
import org.opencypher.grammar.Root;
import org.opencypher.grammar.ScopeRule;
import org.opencypher.grammar.SequenceNode;
import org.opencypher.grammar.TermTransformation;
import org.opencypher.tools.xml.Attribute;
import org.opencypher.tools.xml.Child;
import org.opencypher.tools.xml.Element;

@Element(uri="http://opencypher.org/grammar", name="production")
final class ProductionNode
extends Located
implements Production {
    final String vocabulary;
    @Attribute
    String name;
    @Attribute(optional=true, uri="http://opencypher.org/scope", name="rule")
    ScopeRule scopeRule;
    Node definition;
    String description;
    @Attribute(uri="http://opencypher.org/railroad", optional=true)
    boolean skip;
    @Attribute(uri="http://opencypher.org/railroad", optional=true)
    boolean inline;
    @Attribute(uri="http://opencypher.org/opencypher", optional=true)
    boolean legacy;
    @Attribute(uri="http://opencypher.org/opencypher", optional=true)
    boolean lexer;
    private List<NonTerminal> references;

    public ProductionNode(Root root) {
        this.vocabulary = root.language;
    }

    @Child(value={AlternativesNode.class, SequenceNode.class, LiteralNode.class, CharacterSetNode.class, NonTerminalNode.class, OptionalNode.class, RepetitionNode.class})
    void add(Node node) {
        this.definition = SequenceNode.implicit(this.definition, node.replaceWithVerified());
    }

    @Child
    void add(Description description) {
        this.description = this.description != null ? description.appendTo(this.description) : description.toString();
    }

    @Child
    final void literal(char[] buffer, int start, int length) {
        LiteralNode.fromCharacters(buffer, start, length, this::add);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public <Scope> Scope scope(Scope scope, ScopeRule.Transformation<Scope> transition) {
        return this.scopeRule == null ? scope : this.scopeRule.transform(scope, transition);
    }

    <EX extends Exception> void accept(ProductionVisitor<EX> visitor) throws EX {
        visitor.visitProduction(this);
    }

    <R, P, EX extends Exception> R transform(ProductionTransformation<P, R, EX> transformation, P param) throws EX {
        return transformation.transformProduction(param, this);
    }

    @Override
    public <P, T, EX extends Exception> T transform(TermTransformation<P, T, EX> transformation, P param) throws EX {
        return this.definition().transform(transformation, param);
    }

    @Override
    public boolean skip() {
        return this.skip;
    }

    @Override
    public boolean inline() {
        return this.inline;
    }

    @Override
    public boolean legacy() {
        return this.legacy;
    }

    @Override
    public boolean lexer() {
        return this.lexer;
    }

    void addReference(NonTerminalNode nonTerminal) {
        if (this.references == null) {
            this.references = new ArrayList<NonTerminal>();
        }
        this.references.add(nonTerminal);
    }

    @Override
    public Collection<NonTerminal> references() {
        return this.references == null ? Collections.emptyList() : this.references;
    }

    @Override
    public Node definition() {
        return this.definition == null ? Node.epsilon() : this.definition;
    }

    void resolve(ProductionResolver resolver) {
        if (this.definition != null) {
            this.definition.resolve(this, resolver);
        }
    }

    public int hashCode() {
        return Objects.hashCode(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj.getClass() != ProductionNode.class) {
            return false;
        }
        ProductionNode that = (ProductionNode)obj;
        return Objects.equals(this.name, that.name) && Objects.equals(this.vocabulary, that.vocabulary) && Objects.equals((Object)this.scopeRule, (Object)that.scopeRule) && Objects.equals(this.description, that.description) && Objects.equals(this.definition, that.definition);
    }

    public String toString() {
        return "Production{" + this.vocabulary + " / " + this.name + " = " + this.definition + "}";
    }
}

