/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.grammar;

import java.util.NoSuchElementException;
import java.util.Objects;
import org.opencypher.grammar.Node;
import org.opencypher.grammar.NonTerminal;
import org.opencypher.grammar.Production;
import org.opencypher.grammar.ProductionNode;
import org.opencypher.grammar.ProductionResolver;
import org.opencypher.grammar.TermTransformation;
import org.opencypher.tools.xml.Attribute;
import org.opencypher.tools.xml.Element;

@Element(uri="http://opencypher.org/grammar", name="non-terminal")
final class NonTerminalNode
extends Node
implements NonTerminal {
    @Attribute
    String ref;
    @Attribute(uri="http://opencypher.org/railroad", optional=true)
    Boolean skip;
    @Attribute(uri="http://opencypher.org/railroad", optional=true)
    Boolean inline;
    @Attribute(uri="http://opencypher.org/railroad", optional=true)
    String title;
    private ProductionNode production;
    private int index = -1;
    private ProductionNode origin;

    NonTerminalNode() {
    }

    @Override
    public ProductionNode production() {
        if (this.production == null) {
            throw new NoSuchElementException(this.ref);
        }
        return this.production;
    }

    @Override
    public boolean skip() {
        return this.skip == null ? this.production().skip : this.skip;
    }

    @Override
    public boolean inline() {
        return this.inline == null ? this.production().inline : this.inline;
    }

    @Override
    public String title() {
        return this.title == null ? this.production().name : this.title;
    }

    @Override
    public Production declaringProduction() {
        return this.origin;
    }

    @Override
    boolean resolve(ProductionNode origin, ProductionResolver resolver) {
        this.production = resolver.resolveProduction(origin, Objects.requireNonNull(this.ref, "non-terminal reference"));
        if (this.production != null) {
            this.production.addReference(this);
            if (this.index < 0) {
                this.origin = origin;
                this.index = resolver.nextNonTerminalIndex();
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.ref);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj.getClass() != NonTerminalNode.class) {
            return false;
        }
        NonTerminalNode that = (NonTerminalNode)obj;
        return Objects.equals(this.ref, that.ref);
    }

    @Override
    public String toString() {
        return "NonTerminal{" + this.ref + "}";
    }

    @Override
    public <P, T, EX extends Exception> T transform(TermTransformation<P, T, EX> transformation, P param) throws EX {
        return transformation.transformNonTerminal(param, this);
    }
}

