/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.generator;

import java.util.Objects;
import java.util.function.Supplier;
import org.opencypher.generator.Choices;
import org.opencypher.generator.Node;
import org.opencypher.generator.ProductionReplacement;
import org.opencypher.generator.TreeBuilder;
import org.opencypher.grammar.Grammar;
import org.opencypher.tools.Functions;
import org.opencypher.tools.io.Output;

public final class Generator {
    private final Grammar grammar;
    private final TreeBuilder<?> builder;

    @SafeVarargs
    public Generator(Grammar grammar, ProductionReplacement<Void> ... replacements) {
        this(Choices.SIMPLE, grammar, replacements);
    }

    @SafeVarargs
    public <T> Generator(Grammar grammar, Supplier<T> context, ProductionReplacement<T> ... replacements) {
        this(Choices.SIMPLE, grammar, context, replacements);
    }

    @SafeVarargs
    public Generator(Choices random, Grammar grammar, ProductionReplacement<Void> ... replacements) {
        this(random, grammar, () -> null, replacements);
    }

    @SafeVarargs
    public <T> Generator(Choices random, Grammar grammar, Supplier<T> context, ProductionReplacement<T> ... replacements) {
        this.grammar = grammar;
        this.builder = new TreeBuilder<T>(Functions.requireNonNull(Choices.class, random), Objects.requireNonNull(context, "context"), Functions.map(replacement -> {
            String name = replacement.production();
            if (!grammar.hasProduction(name)) {
                throw new IllegalArgumentException("Grammar for " + grammar.language() + " does not contain a production for " + replacement.production());
            }
            return name;
        }, replacements));
    }

    public void generate(String start, Output output) {
        this.generateTree(start).write(output);
    }

    public void generate(Output output) {
        this.generate(this.grammar.language(), output);
    }

    Node generateTree(String start) {
        return Generator.generateTree(this.grammar, this.builder, start);
    }

    private static <T> Node generateTree(Grammar grammar, TreeBuilder<T> builder, String start) {
        return builder.buildTree((TreeBuilder.State)grammar.transform(start, builder, null));
    }
}

