/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.generator;

import java.util.concurrent.ThreadLocalRandom;
import org.opencypher.generator.Node;
import org.opencypher.grammar.BiasedTerms;
import org.opencypher.grammar.CharacterSet;
import org.opencypher.grammar.Grammar;
import org.opencypher.grammar.Optional;
import org.opencypher.grammar.Repetition;

public interface Choices {
    public static final Choices SIMPLE = new Choices(){

        @Override
        public Grammar.Term choose(Node location, BiasedTerms alternatives) {
            return alternatives.term(Choices.random(alternatives.bound()));
        }

        @Override
        public int repetition(Node location, Repetition rep) {
            return Choices.times(rep);
        }

        @Override
        public boolean includeOptional(Node location, Optional optional) {
            return Choices.random() < optional.probability();
        }

        @Override
        public int codePoint(Node location, CharacterSet characters) {
            return characters.randomCodePoint(ThreadLocalRandom.current());
        }
    };

    public Grammar.Term choose(Node var1, BiasedTerms var2);

    public int repetition(Node var1, Repetition var2);

    public boolean includeOptional(Node var1, Optional var2);

    public int codePoint(Node var1, CharacterSet var2);

    public static double random() {
        return ThreadLocalRandom.current().nextDouble();
    }

    public static double random(double bound) {
        return ThreadLocalRandom.current().nextDouble(bound);
    }

    public static int random(int min, int max) {
        if (max == Integer.MAX_VALUE) {
            return ThreadLocalRandom.current().nextInt(min);
        }
        return ThreadLocalRandom.current().nextInt(min, max + 1);
    }

    public static int normal(int min, int norm, double scale) {
        int shift = norm - min;
        double v = Choices.normal(scale) + (double)shift;
        if (v < 0.0 && (v += (double)shift) < 0.0) {
            v = -v;
        }
        return (int)(v + (double)min);
    }

    public static int times(Repetition rep) {
        int min = rep.minTimes();
        double norm = rep.norm() - min;
        if (rep.limited()) {
            int n = rep.maxTimes() - min;
            if (norm == 0.0) {
                norm = 0.5;
            } else if ((double)n == norm) {
                norm -= 0.5 - Math.sqrt(0.02) / norm;
            }
            return min + Choices.binomial(n, norm / (double)n);
        }
        return min + Choices.poisson(norm + 0.5);
    }

    public static double normal(double scale) {
        return ThreadLocalRandom.current().nextGaussian() * scale;
    }

    public static int poisson(double lambda) {
        double L = Math.exp(-lambda);
        double p = 1.0;
        int k = 0;
        do {
            ++k;
        } while ((p *= Choices.random()) > L);
        return k - 1;
    }

    public static int binomial(int n, double p) {
        int x = 0;
        for (int i = 0; i < n; ++i) {
            if (!(Choices.random() < p)) continue;
            ++x;
        }
        return x;
    }
}

