/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public abstract class XmlGenerator
implements XMLReader {
    private static final char[] WHITESPACE = new char[1025];
    private int level;
    private boolean children;
    private EntityResolver resolver;
    private DTDHandler dtdHandler;
    private ContentHandler handler;
    private ErrorHandler errors;
    private Map<String, String> uris;

    protected static void generate(XmlGenerator generator, Writer writer) throws TransformerException {
        XmlGenerator.generate(generator, new StreamResult(writer));
    }

    protected static void generate(XmlGenerator generator, OutputStream stream) throws TransformerException {
        XmlGenerator.generate(generator, new StreamResult(stream));
    }

    protected static Document generate(XmlGenerator generator) throws TransformerException {
        DOMResult dom = new DOMResult();
        XmlGenerator.generate(generator, dom);
        return (Document)dom.getNode();
    }

    static void generate(XmlGenerator generator, Result result) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.transform(new SAXSource(generator, new InputSource()), result);
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.resolver;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this.dtdHandler = handler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.handler = handler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.handler;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.errors = handler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errors;
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        this.generate();
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        this.generate();
    }

    protected abstract void generate() throws SAXException;

    protected final AttributesBuilder attribute(String name, String value) {
        return this.attribute("", name, value);
    }

    protected final AttributesBuilder attribute(String prefix, String name, String value) {
        return new AttributesBuilder(this).attribute(prefix, name, value);
    }

    protected final void startDocument() throws SAXException {
        this.uris = new HashMap<String, String>();
        this.handler.startDocument();
    }

    protected final void endDocument() throws SAXException {
        this.handler.endDocument();
        this.uris = null;
    }

    protected final void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.uris.put(prefix, uri);
        this.handler.startPrefixMapping(prefix, uri);
    }

    protected final void endPrefixMapping(String prefix) throws SAXException {
        this.handler.endPrefixMapping(prefix);
        this.uris.remove(prefix);
    }

    protected final void startElement(String localName) throws SAXException {
        this.startElement("", localName);
    }

    protected final void startElement(String localName, Attributes attributes) throws SAXException {
        this.startElement("", localName, attributes);
    }

    protected final void startElement(String prefix, String localName) throws SAXException {
        this.startElement(prefix, localName, new AttributesImpl());
    }

    protected final void startElement(String prefix, String localName, Attributes attributes) throws SAXException {
        this.newline();
        ++this.level;
        this.handler.startElement(this.uris.get(prefix), localName, XmlGenerator.qualify(prefix, localName), attributes);
        this.children = false;
    }

    protected final void endElement(String localName) throws SAXException {
        this.endElement("", localName);
    }

    protected final void endElement(String prefix, String localName) throws SAXException {
        --this.level;
        if (this.children) {
            this.newline();
        }
        this.children = true;
        this.handler.endElement(this.uris.get(prefix), localName, XmlGenerator.qualify(prefix, localName));
    }

    protected final void println(CharSequence content) throws SAXException {
        this.newline();
        this.characters(content);
    }

    private void newline() throws SAXException {
        this.characters(WHITESPACE, 0, this.level * 2 + 1);
    }

    protected final void characters(CharSequence content) throws SAXException {
        char[] chars = new char[content.length()];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = content.charAt(i);
        }
        this.characters(chars, 0, chars.length);
    }

    protected final void characters(char[] ch, int start, int length) throws SAXException {
        this.children = true;
        this.handler.characters(ch, start, length);
    }

    private static String qualify(String prefix, String name) {
        return prefix.isEmpty() ? name : prefix + ":" + name;
    }

    static {
        XmlGenerator.WHITESPACE[0] = 10;
        Arrays.fill(WHITESPACE, 1, 1024, ' ');
    }

    protected static class AttributesBuilder
    extends AttributesImpl {
        private static final String CDATA = "CDATA";
        private final Map<String, String> uri;

        protected AttributesBuilder(XmlGenerator generator) {
            this.uri = generator.uris;
        }

        public AttributesBuilder attribute(String name, String value) {
            return this.attribute("", name, value);
        }

        public AttributesBuilder attribute(String prefix, String name, String value) {
            this.addAttribute(this.uri.get(prefix), name, XmlGenerator.qualify(prefix, name), CDATA, value);
            return this;
        }
    }
}

