/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.xml;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import javax.xml.parsers.ParserConfigurationException;
import org.opencypher.tools.xml.Reference;
import org.opencypher.tools.xml.XmlFile;
import org.opencypher.tools.xml.XmlParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

abstract class Resolver {
    private final Set<Path> parsedPaths;
    final EnumSet<XmlParser.Option> options;

    Resolver(XmlParser.Option[] options) {
        this(new HashSet<Path>(), Resolver.options(options));
    }

    private static EnumSet<XmlParser.Option> options(XmlParser.Option[] options) {
        EnumSet<XmlParser.Option> result = EnumSet.noneOf(XmlParser.Option.class);
        if (options != null) {
            Collections.addAll(result, options);
        }
        return result;
    }

    private Resolver(Set<Path> parsedPaths, EnumSet<XmlParser.Option> options) {
        this.parsedPaths = parsedPaths;
        this.options = options;
    }

    final XmlFile file(String path) {
        Path resolved = this.path(path);
        return new XmlFile(new Child(this.parsedPaths, resolved.getParent(), this.options), resolved);
    }

    abstract Path path(String var1);

    boolean parsed(Path path) {
        return this.parsedPaths.contains(path);
    }

    <T> T parse(Path path, XmlParser<T> parser) throws IOException, SAXException, ParserConfigurationException {
        this.parsedPaths.add(path);
        try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
            InputSource input = new InputSource(stream);
            input.setSystemId(XmlFile.canonicalize(path));
            T t = parser.parse(this, input, this.options);
            return t;
        }
    }

    static void initialize(Initializer init) {
        init.add(Resolver::file);
    }

    private static Function<MethodHandle, MethodHandle> conversion(MethodHandle filter) {
        return mh -> MethodHandles.collectArguments(mh, 1, filter);
    }

    private static class Child
    extends Resolver {
        private final Path base;

        Child(Set<Path> parsedPaths, Path base, EnumSet<XmlParser.Option> options) {
            super(parsedPaths, options);
            this.base = base;
        }

        @Override
        Path path(String path) {
            return this.base.resolve(path);
        }
    }

    static interface Initializer {
        public void add(Class<?> var1, Function<MethodHandle, MethodHandle> var2);

        default public <T> void add(Reference.BiFunction<Resolver, String, T> conversion) {
            MethodHandle mh = conversion.mh();
            this.add((Class<?>)mh.type().returnType(), Resolver.conversion(mh));
        }
    }
}

