/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

@FunctionalInterface
public interface LineInput {
    public String read();

    public static LineInput stdIn() {
        return LineInput.input(System.in);
    }

    public static LineInput input(InputStream input) {
        return LineInput.input(new BufferedReader(new InputStreamReader(input)));
    }

    public static LineInput input(Reader in) {
        BufferedReader input = in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in);
        return () -> {
            try {
                return input.readLine();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        };
    }
}

