/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.grammar;

import java.awt.Font;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.opencypher.grammar.Grammar;
import org.opencypher.tools.Option;
import org.opencypher.tools.Reflection;
import org.opencypher.tools.grammar.Main;
import org.opencypher.tools.io.Output;

abstract class Tool
implements Function<Method, Object> {
    private final String prefix = this.getClass().getSimpleName() + ".";
    private final Map<?, ?> properties;

    Tool(Map<?, ?> properties) {
        this.properties = properties;
    }

    protected static <T extends Tool> void main(final Constructor<T> constructor, final Entry<T> entry, String ... args) throws Exception {
        Main.execute(new Main(){

            @Override
            public void write(Grammar grammar, OutputStream out) throws Exception {
                entry.invoke(constructor.create(System.getProperties()), grammar, Output.output(out));
            }

            @Override
            public String usage(BiFunction<String, String, String> usage) {
                Class<?> implClass = Reflection.lambdaClass(constructor);
                return usage.apply(Reflection.pathOf(implClass), implClass.getName());
            }
        }, args);
    }

    @SafeVarargs
    protected final <T> T options(Class<T> type, Option<T> ... options) {
        return Option.dynamicOptions(type, this, new Option[0]);
    }

    protected final Path outputDir() throws IOException {
        Object outputDir = this.get("outputDir");
        Path path = outputDir instanceof Path ? (Path)outputDir : (outputDir instanceof String ? Paths.get((String)outputDir, new String[0]) : Paths.get(".", new String[0]));
        Path output = path.normalize().toAbsolutePath();
        if (!Files.isDirectory(output, new LinkOption[0])) {
            Files.createDirectories(output, new FileAttribute[0]);
        } else {
            Object clearOutputDir = this.get("clearOutputDir");
            boolean clear = false;
            if (clearOutputDir instanceof Boolean) {
                clear = (Boolean)clearOutputDir;
            } else if (clearOutputDir instanceof String) {
                clear = Boolean.parseBoolean((String)clearOutputDir);
            }
            if (clear) {
                Tool.clearDirectory(output);
            }
        }
        return output;
    }

    private String lookup(String name) {
        Object value = this.get(name);
        return value instanceof String ? (String)value : null;
    }

    private Object get(String name) {
        return this.properties.get(this.prefix + name);
    }

    @Override
    public final Object apply(Method key) {
        String name;
        Object value;
        Class<?> type = key.getReturnType();
        if (type.isInstance(value = this.get(name = key.getName()))) {
            return value;
        }
        if (value instanceof String) {
            String param = (String)value;
            switch (type.getName()) {
                case "float": {
                    return Float.valueOf(Float.parseFloat(param));
                }
                case "double": {
                    return Double.parseDouble(param);
                }
                case "long": {
                    return Long.parseLong(param);
                }
                case "int": {
                    return Integer.parseInt(param);
                }
                case "short": {
                    return Short.parseShort(param);
                }
                case "byte": {
                    return Byte.parseByte(param);
                }
                case "boolean": {
                    return Boolean.parseBoolean(param);
                }
                case "java.awt.Font": {
                    return this.awtFont(key, param);
                }
                case "javafx.scene.text.Font": {
                    return this.fxFont(key, param);
                }
            }
        } else if (value == null) {
            if (type == Font.class) {
                return this.awtFont(key, this.lookup(name + ".name"));
            }
            if (type == javafx.scene.text.Font.class) {
                return this.fxFont(key, this.lookup(name + ".family"));
            }
        }
        return null;
    }

    private Font awtFont(Method method, String font) {
        String size;
        String italic;
        String bold;
        block9: {
            String name = method.getName();
            bold = this.lookup(name + ".bold");
            italic = this.lookup(name + ".italic");
            size = this.lookup(name + ".size");
            if (font == null && bold == null && italic == null && size == null) {
                return null;
            }
            if (font == null || size == null) {
                try {
                    Font def = (Font)method.invoke(Option.options(method.getDeclaringClass(), new Option[0]), new Object[0]);
                    if (font == null) {
                        font = def.getName();
                    }
                    if (size == null) {
                        size = "" + def.getSize();
                    }
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    if (font == null) {
                        font = "sans";
                    }
                    if (size != null) break block9;
                    size = "10";
                }
            }
        }
        int style = 0;
        if (Boolean.parseBoolean(bold)) {
            style |= 1;
        }
        if (Boolean.parseBoolean(italic)) {
            style |= 2;
        }
        return new Font(font, style, Integer.parseInt(size));
    }

    private javafx.scene.text.Font fxFont(Method method, String family) {
        return javafx.scene.text.Font.font((String)family);
    }

    private static void clearDirectory(final Path output) throws IOException {
        Files.walkFileTree(output, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (exc != null) {
                    return FileVisitResult.TERMINATE;
                }
                if (!dir.equals(output)) {
                    Files.delete(dir);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    static interface Entry<T> {
        public void invoke(T var1, Grammar var2, Output var3) throws Exception;
    }

    static interface Constructor<T>
    extends Serializable {
        public T create(Map<?, ?> var1);
    }
}

