/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.opencypher.tools.Functions;
import org.opencypher.tools.Reflection;

@FunctionalInterface
public interface Option<T>
extends Serializable {
    public Object value(T var1);

    @SafeVarargs
    public static <T> T dynamicOptions(Class<T> optionsType, Function<Method, Object> lookup, Option<? super T> ... options) {
        return (T)OptionHandler.create(optionsType, Objects.requireNonNull(lookup, "lookup"), options);
    }

    @SafeVarargs
    public static <T> T options(Class<T> optionsType, Option<? super T> ... options) {
        return (T)OptionHandler.create(optionsType, null, options);
    }

    public static class OptionHandler<T>
    implements InvocationHandler {
        private final Function<Method, Object> dynamic;
        private final Map<String, Option<? super T>> options;

        @SafeVarargs
        private static <T> T create(Class<T> iFace, Function<Method, Object> lookup, Option<? super T> ... options) {
            if (!iFace.isInterface()) {
                throw new IllegalArgumentException("options must be an interface: " + iFace);
            }
            HashMap optionMap = new HashMap(Functions.map(Arrays.asList(options), Reflection::lambdaParameterName));
            Map<String, Method> methods = Functions.map(Arrays.asList(iFace.getMethods()), method -> {
                if (method.getDeclaringClass() == Object.class) {
                    return null;
                }
                if (method.getParameterCount() != 0) {
                    throw new IllegalArgumentException("Options interface may not have methods with parameters: " + method);
                }
                if (!method.isDefault() && !optionMap.containsKey(method.getName()) && lookup == null) {
                    throw new IllegalArgumentException("Missing required option: " + method.getName());
                }
                return method.getName();
            });
            optionMap.keySet().forEach(name -> {
                Method method = (Method)methods.get(name);
                if (method == null) {
                    throw new IllegalArgumentException("No such option: " + name);
                }
            });
            return iFace.cast(Proxy.newProxyInstance(iFace.getClassLoader(), new Class[]{iFace}, new OptionHandler<T>(lookup == null ? name -> null : lookup, optionMap)));
        }

        private OptionHandler(Function<Method, Object> dynamic, Map<String, Option<? super T>> options) {
            this.dynamic = dynamic;
            this.options = options;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String name;
            Option<Object> option;
            if (method.getDeclaringClass() == Object.class) {
                switch (method.getName()) {
                    case "toString": {
                        return proxy.getClass().getName();
                    }
                    case "hashCode": {
                        return System.identityHashCode(proxy);
                    }
                    case "equals": {
                        return proxy == args[0];
                    }
                }
            }
            if ((option = this.options.get(name = method.getName())) == null) {
                Object value = this.dynamic.apply(method);
                if (value != null) {
                    option = OptionHandler.option(value);
                    this.options.put(name, option);
                } else {
                    option = OptionHandler.option(Reflection.defaultInvoker(method));
                    this.options.put(name, option);
                }
            }
            return OptionHandler.invoke(option, proxy);
        }

        private static Object invoke(Option option, Object options) {
            return option.value(options);
        }

        private static <T> Option<T> option(Object value) {
            return options -> value;
        }

        private static <T> Option<T> option(MethodHandle invoker) {
            return options -> Reflection.invoke(invoker, options);
        }
    }
}

