/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class Functions {
    private static final Collector<Optional, List, List> FLAT_LIST = Collector.of(ArrayList::new, (result, item) -> item.ifPresent(result::add), (lhs, rhs) -> {
        ArrayList result = new ArrayList(lhs.size() + rhs.size());
        result.addAll(lhs);
        result.addAll(rhs);
        return result;
    }, new Collector.Characteristics[0]);

    public static <T> T requireNonNull(Class<T> type, T value) {
        return Objects.requireNonNull(value, type::getSimpleName);
    }

    public static <I, O> Supplier<O> map(Supplier<I> source, Function<I, O> map) {
        return () -> map.apply(source.get());
    }

    @SafeVarargs
    public static <K, V> Map<K, V> map(Function<V, K> key, V ... values) {
        return values == null || values.length == 0 ? Collections.emptyMap() : Functions.map(Arrays.asList(values), key);
    }

    public static <T> T identity(T value) {
        return value;
    }

    public static <K, V> Map<K, V> map(Collection<V> values, Function<V, K> key) {
        if (Objects.requireNonNull(values, "values").size() == 0) {
            return Collections.emptyMap();
        }
        Objects.requireNonNull(key, "key function");
        HashMap<K, V> result = new HashMap<K, V>((int)((double)values.size() / 0.75));
        for (V value : values) {
            K k = key.apply(value);
            if (k == null || result.put(k, value) == null) continue;
            throw new IllegalArgumentException("Duplicate key: " + k);
        }
        return result;
    }

    public static <T> Collector<Optional<T>, List<T>, List<T>> flatList() {
        return FLAT_LIST;
    }
}

