/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.grammar;

import java.util.Objects;
import org.opencypher.grammar.Node;
import org.opencypher.grammar.Repetition;
import org.opencypher.grammar.Sequenced;
import org.opencypher.grammar.TermTransformation;
import org.opencypher.tools.xml.Attribute;
import org.opencypher.tools.xml.Element;

@Element(uri="http://opencypher.org/grammar", name="repeat")
class RepetitionNode
extends Sequenced
implements Repetition {
    @Attribute(optional=true)
    int min;
    @Attribute(optional=true)
    Integer max;
    @Attribute(optional=true, uri="http://opencypher.org/stringgeneration")
    Integer norm;

    RepetitionNode() {
    }

    @Override
    <T, P, EX extends Exception> T transform(TermTransformation<P, T, EX> transformation, P param, Node term) throws EX {
        return transformation.transformRepetition(param, this);
    }

    @Override
    public int minTimes() {
        return this.min;
    }

    @Override
    public boolean limited() {
        return this.max != null;
    }

    @Override
    public int maxTimes() {
        if (this.max == null) {
            throw new IllegalStateException("Unlimited repetition");
        }
        return this.max;
    }

    @Override
    public int norm() {
        if (this.norm == null) {
            return this.min;
        }
        return this.norm;
    }

    @Override
    int attributeHash() {
        return Objects.hash(this.min, this.max);
    }

    @Override
    boolean attributeEquals(Sequenced obj) {
        RepetitionNode that = (RepetitionNode)obj;
        return Objects.equals(this.min, that.min) && Objects.equals(this.max, that.max);
    }

    @Override
    void attributeString(StringBuilder result) {
        if (this.min > 0) {
            result.append("{min=").append(this.min);
        }
        if (this.max != null) {
            result.append(this.min > 0 ? "{max=" : ",max=").append(this.max);
        }
        if (this.min > 0 || this.max != null) {
            result.append('}');
        }
    }
}

