/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.grammar;

import java.util.Iterator;
import java.util.stream.Stream;
import org.opencypher.grammar.BiasedTerms;
import org.opencypher.grammar.Grammar;
import org.opencypher.grammar.Node;

public class Nodes
implements BiasedTerms {
    private final Node[] terms;
    private double bias;

    Nodes(Stream<Node> terms) {
        this.terms = (Node[])terms.peek(node -> this.bias += node.bias).toArray(Node[]::new);
    }

    @Override
    public int terms() {
        return this.terms.length;
    }

    @Override
    public Grammar.Term term(int offset) {
        return this.terms[offset];
    }

    @Override
    public double bound() {
        return this.bias;
    }

    @Override
    public Grammar.Term term(double bias) {
        double remaining = bias;
        for (Node term : this.terms) {
            if (!((remaining -= term.bias) < 0.0)) continue;
            return term;
        }
        throw new IllegalArgumentException("Bias not in range: " + bias);
    }

    @Override
    public Iterator<Grammar.Term> iterator() {
        return new Iterator<Grammar.Term>(){
            int i;

            @Override
            public boolean hasNext() {
                return this.i < Nodes.this.terms.length;
            }

            @Override
            public Grammar.Term next() {
                return Nodes.this.terms[this.i++];
            }
        };
    }
}

