/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.grammar;

import java.util.Objects;
import java.util.Random;
import org.opencypher.grammar.CharacterSet;
import org.opencypher.grammar.CodePointSet;
import org.opencypher.grammar.Except;
import org.opencypher.grammar.Node;
import org.opencypher.grammar.TermTransformation;
import org.opencypher.tools.xml.Attribute;
import org.opencypher.tools.xml.Child;
import org.opencypher.tools.xml.Element;

@Element(uri="http://opencypher.org/grammar", name="character")
class CharacterSetNode
extends Node
implements CharacterSet {
    static final String DEFAULT_SET = CharacterSet.Unicode.ANY.name();
    private static final String EOF = "EOF";
    private CodePointSet set = CodePointSet.ANY;

    CharacterSetNode() {
    }

    @Attribute(optional=true)
    public void set(String set) {
        try {
            this.set = CharacterSet.Unicode.valueOf((String)set).set;
        }
        catch (IllegalArgumentException e) {
            if ("EOI".equals(set) || EOF.equals(set)) {
                this.set = null;
            }
            if (set.length() > 2 && set.charAt(0) == '[' && set.charAt(set.length() - 1) == ']') {
                this.set = CodePointSet.parse(set);
            }
            throw new IllegalArgumentException("Invalid character set, should either be the name of a well known set, or a set enclosed in '[...]', not: " + set);
        }
    }

    @Override
    CharacterSetNode defensiveCopy() {
        CharacterSetNode characters = new CharacterSetNode();
        characters.set = this.set;
        return characters;
    }

    void exclude(int ... codePoints) {
        this.exclude(CodePointSet.codePoints(codePoints));
    }

    @Child
    void add(Except exception) {
        this.exclude(exception.set());
    }

    private void exclude(CodePointSet excepted) {
        if (this.set == null) {
            throw new IllegalArgumentException("Cannot exclude code points from EOI");
        }
        this.set = this.set.except(excepted);
    }

    @Override
    Node replaceWithVerified() {
        return super.replaceWithVerified();
    }

    @Override
    boolean isEligibleForGeneration() {
        return this.set != null && super.isEligibleForGeneration();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CharacterSetNode)) {
            return false;
        }
        CharacterSetNode that = (CharacterSetNode)o;
        return Objects.equals(this.set, that.set);
    }

    @Override
    public int hashCode() {
        return this.set.hashCode();
    }

    @Override
    public String toString() {
        return String.format("Characters{%s}", this.set == null ? "EOI" : this.set);
    }

    @Override
    public <P, T, EX extends Exception> T transform(TermTransformation<P, T, EX> transformation, P param) throws EX {
        return transformation.transformCharacters(param, this);
    }

    @Override
    public String name() {
        return this.set == null ? "EOI" : this.set.name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <EX extends Exception> void accept(CharacterSet.DefinitionVisitor<EX> visitor) throws EX {
        if (this.set == null) {
            if (!(visitor instanceof CharacterSet.DefinitionVisitor.NamedSetVisitor)) throw new UnsupportedOperationException("visitSet(EOI)");
            ((CharacterSet.DefinitionVisitor.NamedSetVisitor)visitor).visitSet("EOI").close();
            return;
        } else {
            this.set.accept(visitor);
        }
    }

    @Override
    public int randomCodePoint(Random random) {
        if (this.set == null) {
            throw new IllegalArgumentException("Cannot generate EOI");
        }
        return this.set.randomCodePoint(random);
    }

    @Override
    public boolean contains(int codePoint) {
        return this.set != null && this.set.contains(codePoint);
    }

    static boolean isReserved(String name) {
        if ("ANY".equals(name) || "EOI".equals(name) || EOF.equals(name)) {
            return true;
        }
        try {
            if (CharacterSet.Unicode.valueOf(name) == null) {
                return false;
            }
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static CharacterSetNode charSet(String name) {
        CharacterSetNode result = new CharacterSetNode();
        result.set(name);
        return result;
    }
}

