/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.generator;

import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import javax.xml.parsers.ParserConfigurationException;
import org.opencypher.generator.Choices;
import org.opencypher.generator.Generator;
import org.opencypher.generator.ProductionReplacement;
import org.opencypher.grammar.Grammar;
import org.xml.sax.SAXException;

public abstract class GeneratorFactory<T> {
    private final ProductionReplacement<T>[] replacements = this.replacements();
    private static final Class[] ARGS = new Class[]{ProductionReplacement.Context.class};

    protected abstract T newContext();

    public final Generator generatorResource(String resource, Grammar.ParserOption ... options) throws ParserConfigurationException, SAXException, IOException {
        URL url = this.getClass().getResource(resource);
        if (url == null) {
            throw new IllegalArgumentException("No such resource: " + resource);
        }
        try {
            return this.generator(Paths.get(url.toURI()), options);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public final Generator generator(Path path, Grammar.ParserOption ... options) throws IOException, SAXException, ParserConfigurationException {
        return this.generator(Grammar.parseXML(path, options));
    }

    public final Generator generator(Grammar grammar) {
        return new Generator(this.choices(), grammar, this::newContext, this.replacements);
    }

    protected Choices choices() {
        return Choices.SIMPLE;
    }

    protected GeneratorFactory() {
    }

    public final ProductionReplacement<T> replacement(String production) {
        Objects.requireNonNull(production, "production");
        return Stream.of(this.replacements).filter(repl -> production.equals(repl.production())).findFirst().get();
    }

    /*
     * WARNING - void declaration
     */
    private ProductionReplacement<T>[] replacements() {
        void var4_5;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        ArrayList<ProductionReplacement<T>> replacements = new ArrayList<ProductionReplacement<T>>();
        Type contextType = null;
        Class<?> clazz = this.getClass();
        while (var4_5 != GeneratorFactory.class) {
            Method[] methodArray = var4_5.getDeclaredMethods();
            int n = methodArray.length;
            for (int i = 0; i < n; ++i) {
                Method method = methodArray[i];
                if (!"newContext".equals(method.getName()) || method.getParameterCount() != 0 || Modifier.isStatic(method.getModifiers()) || method.isBridge()) continue;
                if (contextType != null) {
                    throw new IllegalArgumentException("Could not find context type, too many newContext() methods!");
                }
                contextType = method.getGenericReturnType();
            }
            if (contextType != null) break;
            Class clazz2 = var4_5.getSuperclass();
        }
        if (contextType == null) {
            throw new IllegalArgumentException("Could not find context type, no newContext() method found.");
        }
        for (Method method : this.getClass().getMethods()) {
            MethodHandle mh;
            Replacement annotation = method.getAnnotation(Replacement.class);
            if (annotation == null) continue;
            if (Modifier.isStatic(method.getModifiers())) {
                throw new IllegalArgumentException("Replacement method must not be static.");
            }
            if (!Arrays.equals(method.getParameterTypes(), ARGS)) {
                throw new IllegalArgumentException("Replacement method parameter list must be " + Arrays.toString(ARGS));
            }
            Type paramType = method.getGenericParameterTypes()[0];
            if (!(paramType instanceof ParameterizedType)) {
                throw new IllegalArgumentException("Replacement method parameter must be parameterized.");
            }
            if (!contextType.equals(((ParameterizedType)paramType).getActualTypeArguments()[0])) {
                throw new IllegalArgumentException("Replacement method parameter must match the context type: " + contextType + ", was: " + ((ParameterizedType)paramType).getActualTypeArguments()[0]);
            }
            if (method.getReturnType() != Void.TYPE) {
                throw new IllegalArgumentException("Replacement method should not return a value (must declare void).");
            }
            String[] productions = annotation.value();
            if (productions == null || productions.length == 0) {
                productions = new String[]{method.getName()};
            }
            try {
                mh = lookup.unreflect(method);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Replacement method must be accessible (public).");
            }
            mh = mh.bindTo(this);
            for (String production : productions) {
                replacements.add(GeneratorFactory.replacement(production, mh));
            }
        }
        ProductionReplacement[] productionReplacementArray = replacements.toArray(new ProductionReplacement[replacements.size()]);
        return productionReplacementArray;
    }

    private static <T> ProductionReplacement<T> replacement(final String production, final MethodHandle target) {
        return new ProductionReplacement<T>(){

            @Override
            public String production() {
                return production;
            }

            @Override
            public void replace(ProductionReplacement.Context<T> context) {
                try {
                    target.invokeExact(context);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface Replacement {
        public String[] value() default {};
    }
}

