/*
 * Decompiled with CFR 0.152.
 */
package org.opencadc.token;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.opencadc.token.Assets;
import org.opencadc.token.TokenStore;
import redis.clients.jedis.JedisPooled;

class RedisTokenStore
implements TokenStore {
    private static final String ACCESS_TOKEN_FIELD = "accessToken";
    private static final String REFRESH_TOKEN_FIELD = "refreshToken";
    private static final String EXPIRES_AT_MS_TOKEN_FIELD = "expiresAtMS";
    private static final String KEY_FIELD = "asset_key_index";
    private final JedisPooled jedisPool;

    RedisTokenStore() {
        this.jedisPool = new JedisPooled();
    }

    RedisTokenStore(String url) {
        this.jedisPool = new JedisPooled(url);
    }

    @Override
    public String put(Assets assets) {
        String assetsKey = Long.toString(this.jedisPool.incrBy(KEY_FIELD, 1L));
        this.put(assetsKey, assets);
        return assetsKey;
    }

    @Override
    public void put(String assetsKey, Assets assets) {
        HashMap<String, String> assetsHash = new HashMap<String, String>();
        assetsHash.put(ACCESS_TOKEN_FIELD, assets.getAccessToken());
        assetsHash.put(REFRESH_TOKEN_FIELD, assets.getRefreshToken());
        assetsHash.put(EXPIRES_AT_MS_TOKEN_FIELD, Long.toString(assets.getExpiryTimeMilliseconds()));
        this.jedisPool.hset(assetsKey, assetsHash);
    }

    @Override
    public Assets get(String assetsKey) {
        if (this.jedisPool.exists(assetsKey)) {
            Map assetsHash = this.jedisPool.hgetAll(assetsKey);
            return new Assets((String)assetsHash.get(ACCESS_TOKEN_FIELD), (String)assetsHash.get(REFRESH_TOKEN_FIELD), Long.parseLong((String)assetsHash.get(EXPIRES_AT_MS_TOKEN_FIELD)));
        }
        throw new NoSuchElementException("No asset with key " + assetsKey);
    }
}

