/*
 * Decompiled with CFR 0.152.
 */
package org.opencadc.token;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Base64;
import javax.crypto.spec.SecretKeySpec;

final class EncryptedCookie {
    final byte[] value;
    final byte[] initializationVector;
    final Key secretKey;

    public EncryptedCookie(byte[] value, byte[] initializationVector, Key secretKey) {
        this.value = value;
        this.initializationVector = initializationVector;
        this.secretKey = secretKey;
    }

    public EncryptedCookie(String input) {
        byte[] decodedInput = Base64.getDecoder().decode(input.getBytes(StandardCharsets.ISO_8859_1));
        this.initializationVector = new byte[16];
        System.arraycopy(decodedInput, 0, this.initializationVector, 0, 16);
        byte[] secretKeyBytes = new byte[16];
        System.arraycopy(decodedInput, 16, secretKeyBytes, 0, 16);
        this.secretKey = new SecretKeySpec(secretKeyBytes, "AES");
        int startPos = this.initializationVector.length + secretKeyBytes.length;
        this.value = new byte[decodedInput.length - startPos];
        System.arraycopy(decodedInput, startPos, this.value, 0, this.value.length);
    }

    public byte[] getValue() {
        return this.value;
    }

    public byte[] getInitializationVector() {
        return this.initializationVector;
    }

    public Key getSecretKey() {
        return this.secretKey;
    }

    public byte[] marshall() throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            byteArrayOutputStream.write(this.initializationVector);
            byteArrayOutputStream.write(this.secretKey.getEncoded());
            byteArrayOutputStream.write(this.value);
            byteArrayOutputStream.flush();
            byte[] byArray = Base64.getEncoder().encode(byteArrayOutputStream.toByteArray());
            return byArray;
        }
    }
}

