/*
 * Decompiled with CFR 0.152.
 */
package org.opencadc.token;

import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.RandomStringUtils;
import org.opencadc.token.EncryptedCookie;

class CookieEncrypt {
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";
    private final String algorithm;

    public CookieEncrypt() {
        this(DEFAULT_CIPHER_ALGORITHM);
    }

    CookieEncrypt(String algorithm) {
        this.algorithm = algorithm;
    }

    EncryptedCookie encrypt(String value, Key secretKey) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(this.algorithm);
        byte[] iv = CookieEncrypt.initializeInitializationVector(cipher.getBlockSize());
        cipher.init(1, secretKey, new IvParameterSpec(iv));
        byte[] encryptedValue = Base64.getEncoder().encode(cipher.doFinal(value.getBytes(StandardCharsets.ISO_8859_1)));
        return new EncryptedCookie(encryptedValue, iv, secretKey);
    }

    public EncryptedCookie encrypt(String value) throws GeneralSecurityException {
        return this.encrypt(value, this.generateAESKey());
    }

    private static byte[] initializeInitializationVector(int blockSize) {
        byte[] initializationVector = new byte[blockSize];
        SecureRandom random = new SecureRandom();
        random.nextBytes(initializationVector);
        return initializationVector;
    }

    Key generateAESKey() throws NoSuchAlgorithmException {
        String secretKeyString = RandomStringUtils.randomAlphanumeric((int)16);
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        digest.update(secretKeyString.getBytes(StandardCharsets.ISO_8859_1));
        byte[] keyBytes = new byte[16];
        System.arraycopy(digest.digest(), 0, keyBytes, 0, keyBytes.length);
        return new SecretKeySpec(keyBytes, "AES");
    }
}

