/*
 * Decompiled with CFR 0.152.
 */
package org.opencadc.token;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import org.opencadc.token.EncryptedCookie;

class CookieDecrypt {
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";
    private final String algorithm;

    CookieDecrypt(String algorithm) {
        this.algorithm = algorithm;
    }

    public CookieDecrypt() {
        this(DEFAULT_CIPHER_ALGORITHM);
    }

    public String getAssetsKey(EncryptedCookie encryptedCookie) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Cipher cipher = Cipher.getInstance(this.algorithm);
        cipher.init(2, encryptedCookie.getSecretKey(), new IvParameterSpec(encryptedCookie.getInitializationVector()));
        return new String(cipher.doFinal(Base64.getDecoder().decode(encryptedCookie.getValue())));
    }
}

