/*
 * Decompiled with CFR 0.152.
 */
package org.opencadc.token;

import ca.nrc.cadc.auth.NotAuthenticatedException;
import ca.nrc.cadc.net.HttpGet;
import ca.nrc.cadc.reg.Standards;
import ca.nrc.cadc.reg.client.LocalAuthority;
import ca.nrc.cadc.util.StringUtil;
import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationErrorResponse;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.AuthorizationResponse;
import com.nimbusds.oauth2.sdk.AuthorizationSuccessResponse;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.opencadc.token.Assets;
import org.opencadc.token.CookieDecrypt;
import org.opencadc.token.CookieEncrypt;
import org.opencadc.token.EncryptedCookie;
import org.opencadc.token.RedisTokenStore;
import org.opencadc.token.TokenStore;

public class Client {
    private static final Logger LOGGER = Logger.getLogger(Client.class);
    private static final String WELL_KNOWN_ENDPOINT = "/.well-known/openid-configuration";
    private static final String AUTH_ENDPOINT_KEY = "authorization_endpoint";
    private static final String TOKEN_ENDPOINT_KEY = "token_endpoint";
    private final String clientID;
    private final String clientSecret;
    private final URL callbackURL;
    private final URL redirectURL;
    private final String[] scope;
    private final TokenStore tokenStore;

    public Client(String clientID, String clientSecret, URL callbackURL, URL redirectURL, String[] scope, TokenStore tokenStore) {
        this.clientID = clientID;
        this.clientSecret = clientSecret;
        this.callbackURL = callbackURL;
        this.redirectURL = redirectURL;
        this.scope = scope;
        this.tokenStore = tokenStore;
    }

    public Client(String clientID, String clientSecret, URL callbackURL, URL redirectURL, String[] scope, String tokenStoreCacheURL) {
        this(clientID, clientSecret, callbackURL, redirectURL, scope, new RedisTokenStore(tokenStoreCacheURL));
    }

    public URL getCallbackURL() {
        return this.callbackURL;
    }

    public URL getRedirectURL() {
        return this.redirectURL;
    }

    public URL getAuthorizationURL() throws IOException {
        return this.getAuthorizationURL("");
    }

    public URL getAuthorizationURL(String stateString) throws IOException {
        URI authorizationEndpoint = URI.create(Client.getAuthorizationEndpoint().toExternalForm());
        ClientID clientID = new ClientID(this.clientID);
        Scope scope = new Scope(this.scope);
        URI callback = URI.create(this.redirectURL.toExternalForm());
        AuthorizationRequest.Builder requestBuilder = new AuthorizationRequest.Builder(new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE}), clientID).scope(scope).redirectionURI(callback).endpointURI(authorizationEndpoint);
        if (StringUtil.hasText((String)stateString)) {
            requestBuilder.state(new State(stateString));
        }
        AuthorizationRequest request = requestBuilder.build();
        return request.toURI().toURL();
    }

    public String getAccessToken(String encryptedCookieValue) throws Exception {
        Assets assets;
        String assetsKey = this.getAssetsKey(encryptedCookieValue);
        Assets storedAssets = this.tokenStore.get(assetsKey);
        if (Client.needsRefresh(storedAssets)) {
            Assets refreshedAssets = this.refresh(storedAssets);
            this.tokenStore.put(assetsKey, refreshedAssets);
            assets = refreshedAssets;
        } else {
            assets = storedAssets;
        }
        return assets.getAccessToken();
    }

    public byte[] setAccessToken(URI responseURI) throws Exception {
        AuthorizationCode code = this.getAuthorizationCode(responseURI);
        return this.setAccessToken(code);
    }

    public byte[] setAccessToken(URI responseURI, String state) throws Exception {
        AuthorizationCode code = this.getAuthorizationCode(responseURI, new State(state));
        return this.setAccessToken(code);
    }

    byte[] setAccessToken(AuthorizationCode authorizationCode) throws Exception {
        TokenResponse tokenResponse;
        URI callback = URI.create(this.redirectURL.toExternalForm());
        AuthorizationCodeGrant codeGrant = new AuthorizationCodeGrant(authorizationCode, callback);
        ClientID clientID = new ClientID(this.clientID);
        Secret clientSecret = new Secret(this.clientSecret);
        ClientSecretBasic clientAuth = new ClientSecretBasic(clientID, clientSecret);
        URI tokenEndpoint = URI.create(Client.getTokenEndpoint().toExternalForm());
        TokenRequest tokenRequest = new TokenRequest(tokenEndpoint, (ClientAuthentication)clientAuth, (AuthorizationGrant)codeGrant);
        try {
            tokenResponse = TokenResponse.parse((HTTPResponse)tokenRequest.toHTTPRequest().send());
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Invalid or missing response parameters from token endpoint: " + parseException.getMessage(), parseException);
        }
        if (!tokenResponse.indicatesSuccess()) {
            this.handleTokenErrorResponse(tokenResponse.toErrorResponse());
        }
        AccessTokenResponse tokenSuccessResponse = tokenResponse.toSuccessResponse();
        return this.setAccessToken(new JSONObject(tokenSuccessResponse.toJSONObject().toJSONString()));
    }

    byte[] setAccessToken(JSONObject tokenSet) throws Exception {
        Assets assets = new Assets(tokenSet);
        return this.encryptAssetsKey(this.tokenStore.put(assets));
    }

    byte[] encryptAssetsKey(String assetsKey) throws Exception {
        CookieEncrypt cookieEncrypt = new CookieEncrypt();
        EncryptedCookie encryptionEncryptedCookie = cookieEncrypt.encrypt(assetsKey);
        return encryptionEncryptedCookie.marshall();
    }

    Assets refresh(Assets assets) throws Exception {
        TokenResponse tokenResponse;
        RefreshToken refreshToken = new RefreshToken(assets.getRefreshToken());
        RefreshTokenGrant refreshTokenGrant = new RefreshTokenGrant(refreshToken);
        ClientID clientID = new ClientID(this.clientID);
        Secret clientSecret = new Secret(this.clientSecret);
        ClientSecretBasic clientAuth = new ClientSecretBasic(clientID, clientSecret);
        URI tokenEndpoint = URI.create(Client.getTokenEndpoint().toExternalForm());
        TokenRequest tokenRequest = new TokenRequest(tokenEndpoint, (ClientAuthentication)clientAuth, (AuthorizationGrant)refreshTokenGrant);
        try {
            tokenResponse = TokenResponse.parse((HTTPResponse)tokenRequest.toHTTPRequest().send());
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Invalid or missing response parameters from token endpoint: " + parseException.getMessage(), parseException);
        }
        if (!tokenResponse.indicatesSuccess()) {
            this.handleTokenErrorResponse(tokenResponse.toErrorResponse());
        }
        AccessTokenResponse tokenSuccessResponse = tokenResponse.toSuccessResponse();
        return new Assets(new JSONObject(tokenSuccessResponse.toJSONObject().toJSONString()));
    }

    String getAssetsKey(String encryptedCookieValue) throws Exception {
        EncryptedCookie encryptedEncryptedCookie = new EncryptedCookie(encryptedCookieValue);
        CookieDecrypt cookieDecrypt = new CookieDecrypt();
        return cookieDecrypt.getAssetsKey(encryptedEncryptedCookie);
    }

    AuthorizationCode getAuthorizationCode(URI responseURI) {
        return this.getAuthorizationCode(responseURI, null);
    }

    AuthorizationCode getAuthorizationCode(URI responseURI, State state) {
        AuthorizationResponse response;
        try {
            response = AuthorizationResponse.parse((URI)responseURI);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Invalid or missing response parameters from authorization endpoint: " + parseException.getMessage(), parseException);
        }
        State responseState = response.getState();
        if (responseState == null && state != null) {
            throw new IllegalStateException("Caller state expected, but none provided to compare to by response.");
        }
        if (responseState != null && state == null) {
            throw new IllegalStateException("Response state expected, but none provided to compare to by caller.");
        }
        if (responseState != null && !state.equals((Object)responseState)) {
            throw new NotAuthenticatedException("Caller state does not match request state!  Possible tampering.");
        }
        if (!response.indicatesSuccess()) {
            AuthorizationErrorResponse errorResponse = response.toErrorResponse();
            throw new IllegalArgumentException("Invalid response from authorization server: " + errorResponse);
        }
        AuthorizationSuccessResponse successResponse = response.toSuccessResponse();
        return successResponse.getAuthorizationCode();
    }

    void handleTokenErrorResponse(TokenErrorResponse tokenErrorResponse) {
        ErrorObject tokenErrorObject = tokenErrorResponse.getErrorObject();
        if (tokenErrorObject.getHTTPStatusCode() == 401) {
            throw new NotAuthenticatedException("Refresh token expired.  Please re-authenticate.");
        }
        throw new IllegalArgumentException("Invalid response from token server: " + tokenErrorResponse.toJSONObject());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Client that = (Client)o;
        return Objects.equals(this.clientID, that.clientID) && Objects.equals(this.callbackURL, that.callbackURL) && Objects.equals(this.redirectURL, that.redirectURL) && Arrays.equals(this.scope, that.scope);
    }

    public int hashCode() {
        int result = Objects.hash(this.clientID, this.callbackURL, this.redirectURL);
        result = 31 * result + Arrays.hashCode(this.scope);
        return result;
    }

    public static String generateState() {
        return RandomStringUtils.randomAlphanumeric((int)16);
    }

    public static boolean needsRefresh(Assets assets) {
        return assets.isAccessTokenExpired();
    }

    public static URL getIssuer() throws IOException {
        LocalAuthority localAuthority = new LocalAuthority();
        URI openIDIssuerURI = localAuthority.getServiceURI(Standards.SECURITY_METHOD_OPENID.toASCIIString());
        if (!"https".equals(openIDIssuerURI.getScheme())) {
            throw new UnsupportedOperationException("OpenID Provider not configured.");
        }
        return openIDIssuerURI.toURL();
    }

    public static URL getAuthorizationEndpoint() throws IOException {
        JSONObject jsonObject = Client.getWellKnownJSON();
        String authEndpointString = jsonObject.getString(AUTH_ENDPOINT_KEY);
        return new URL(authEndpointString);
    }

    public static URL getTokenEndpoint() throws IOException {
        JSONObject jsonObject = Client.getWellKnownJSON();
        String tokenEndpointString = jsonObject.getString(TOKEN_ENDPOINT_KEY);
        return new URL(tokenEndpointString);
    }

    private static JSONObject getWellKnownJSON() throws IOException {
        URL oidcIssuer = Client.getIssuer();
        URL configurationURL = new URL(oidcIssuer.toExternalForm() + WELL_KNOWN_ENDPOINT);
        StringWriter writer = new StringWriter();
        HttpGet httpGet = new HttpGet(configurationURL, inputStream -> {
            int charsRead;
            BufferedReader inputReader = new BufferedReader(new InputStreamReader(inputStream));
            char[] buffer = new char[8192];
            while ((charsRead = inputReader.read(buffer)) >= 0) {
                writer.write(buffer, 0, charsRead);
            }
            writer.flush();
        });
        httpGet.run();
        return new JSONObject(((Object)writer).toString());
    }
}

