/*
 * Decompiled with CFR 0.152.
 */
package org.opencadc.token;

import ca.nrc.cadc.util.StringUtil;
import java.util.Objects;
import org.json.JSONObject;

public final class Assets {
    private static final long EXPIRY_BUFFER_CHECK_MS = 60000L;
    static final String ACCESS_TOKEN_KEY = "access_token";
    static final String REFRESH_TOKEN_KEY = "refresh_token";
    static final String EXPIRES_IN_KEY = "expires_in";
    private static final String EXPIRES_AT_MS_KEY = "expires_at_ms";
    private final String accessToken;
    private final String refreshToken;
    private final long expiryTimeMilliseconds;

    public Assets(String accessToken, String refreshToken, long expiryTimeMilliseconds) {
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.expiryTimeMilliseconds = expiryTimeMilliseconds;
    }

    public Assets(JSONObject tokenSet) {
        this.accessToken = tokenSet.getString(ACCESS_TOKEN_KEY);
        this.refreshToken = tokenSet.getString(REFRESH_TOKEN_KEY);
        int expirySeconds = tokenSet.getInt(EXPIRES_IN_KEY);
        this.expiryTimeMilliseconds = System.currentTimeMillis() + (long)expirySeconds * 1000L;
    }

    public String toString() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(ACCESS_TOKEN_KEY, (Object)this.accessToken);
        if (StringUtil.hasText((String)this.refreshToken)) {
            jsonObject.put(REFRESH_TOKEN_KEY, (Object)this.refreshToken);
        }
        jsonObject.put(EXPIRES_AT_MS_KEY, this.expiryTimeMilliseconds);
        return jsonObject.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Assets assets = (Assets)o;
        return this.expiryTimeMilliseconds == assets.expiryTimeMilliseconds && Objects.equals(this.accessToken, assets.accessToken) && Objects.equals(this.refreshToken, assets.refreshToken);
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.refreshToken, this.expiryTimeMilliseconds);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public long getExpiryTimeMilliseconds() {
        return this.expiryTimeMilliseconds;
    }

    public boolean isAccessTokenExpired() {
        return this.expiryTimeMilliseconds < System.currentTimeMillis() - 60000L;
    }
}

