/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.uws;

import ca.nrc.cadc.uws.ErrorSummary;
import ca.nrc.cadc.uws.ExecutionPhase;
import java.util.EventObject;

public class JobEvent
extends EventObject {
    private static final long serialVersionUID = -7622359494477404254L;
    private String eventID;
    private String jobID;
    private ExecutionPhase executionPhase;
    private ErrorSummary errorSummary;

    public JobEvent(Object source, String eventID, String jobID) {
        this(source, eventID, jobID, ExecutionPhase.COMPLETED, null);
    }

    public JobEvent(Object source, String eventID, String jobID, ErrorSummary errorSummary) {
        this(source, eventID, jobID, ExecutionPhase.ERROR, errorSummary);
    }

    public JobEvent(Object source, String eventID, String jobID, ExecutionPhase executionPhase) {
        this(source, eventID, jobID, executionPhase, null);
    }

    private JobEvent(Object source, String eventID, String jobID, ExecutionPhase executionPhase, ErrorSummary errorSummary) {
        super(source);
        this.eventID = eventID;
        this.jobID = jobID;
        this.executionPhase = executionPhase;
        this.errorSummary = errorSummary;
    }

    @Override
    public String toString() {
        return String.format("Job (JobID=[%s] ExecutionPhase=[%s] ErrorSummary=[%s])", new Object[]{this.jobID, this.executionPhase, this.errorSummary});
    }

    public String getEventID() {
        return this.eventID;
    }

    public String getJobID() {
        return this.jobID;
    }

    public ExecutionPhase getExecutionPhase() {
        return this.executionPhase;
    }

    public ErrorSummary getErrorSummary() {
        return this.errorSummary;
    }
}

