/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.uws;

import ca.nrc.cadc.uws.ErrorType;
import java.net.URL;

public class ErrorSummary {
    private String message;
    private ErrorType errorType;
    private boolean hasDetail;
    private URL documentURL;

    private ErrorSummary() {
    }

    public ErrorSummary(String message, ErrorType type) {
        this(message, type, null);
    }

    public ErrorSummary(String message, ErrorType type, URL documentURL) {
        this.message = message;
        this.errorType = type;
        this.documentURL = documentURL;
        this.hasDetail = documentURL != null;
    }

    ErrorSummary(String message, ErrorType type, boolean hasDetail) {
        this.message = message;
        this.errorType = type;
        this.documentURL = null;
        this.hasDetail = hasDetail;
    }

    public String getSummaryMessage() {
        return this.message;
    }

    public URL getDocumentURL() {
        return this.documentURL;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public boolean getHasDetail() {
        return this.hasDetail;
    }

    public String toString() {
        if (this.documentURL != null) {
            return "ErrorSummary[" + this.message + "," + this.errorType + "," + this.documentURL + "]";
        }
        if (this.hasDetail) {
            return "ErrorSummary[" + this.message + "," + this.errorType + "," + this.hasDetail + "]";
        }
        return "ErrorSummary[" + this.message + "," + this.errorType + "]";
    }
}

