/*
 * Decompiled with CFR 0.152.
 */
package org.opencadc.gms;

import ca.nrc.cadc.auth.AuthMethod;
import ca.nrc.cadc.auth.AuthenticationUtil;
import ca.nrc.cadc.cred.client.CredUtil;
import ca.nrc.cadc.net.HttpGet;
import ca.nrc.cadc.net.ResourceAlreadyExistsException;
import ca.nrc.cadc.net.ResourceNotFoundException;
import ca.nrc.cadc.reg.Capabilities;
import ca.nrc.cadc.reg.Capability;
import ca.nrc.cadc.reg.Interface;
import ca.nrc.cadc.reg.Standards;
import ca.nrc.cadc.reg.client.RegistryClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URI;
import java.net.URL;
import java.security.AccessControlException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.opencadc.gms.GroupURI;

public class IvoaGroupClient {
    private static final Logger log = Logger.getLogger(IvoaGroupClient.class);
    private final RegistryClient reg = new RegistryClient();

    public boolean isMember(GroupURI group) throws IOException, InterruptedException, ResourceNotFoundException {
        URI resourceID = group.getServiceID();
        TreeSet<String> names = new TreeSet<String>();
        names.add(group.getName());
        Set<GroupURI> mem = this.getMemberships(resourceID, names);
        return !mem.isEmpty();
    }

    public Set<GroupURI> getMemberships(Set<GroupURI> uris) throws IOException, InterruptedException, ResourceNotFoundException {
        Map<URI, Set<String>> gmsMap = this.splitByResourceID(uris);
        TreeSet<GroupURI> ret = new TreeSet<GroupURI>();
        for (Map.Entry<URI, Set<String>> me : gmsMap.entrySet()) {
            Set<GroupURI> tmp = this.getMemberships(me.getKey(), me.getValue());
            ret.addAll(tmp);
        }
        return ret;
    }

    public Set<GroupURI> getMemberships(URI resourceID) throws IOException, InterruptedException, ResourceNotFoundException {
        return this.getMemberships(resourceID, null);
    }

    public Set<GroupURI> getMemberships(URI resourceID, Set<String> groupNames) throws IOException, InterruptedException, ResourceNotFoundException {
        Subject cur = AuthenticationUtil.getCurrentSubject();
        AuthMethod am = AuthenticationUtil.getAuthMethod((Subject)cur);
        if (am == null || AuthMethod.ANON.equals((Object)am)) {
            throw new UnsupportedOperationException("cannot get group memberships for anonymous");
        }
        Capabilities caps = this.reg.getCapabilities(resourceID);
        if (caps == null) {
            throw new ResourceNotFoundException("service not found in registry: " + resourceID);
        }
        Capability cap = caps.findCapability(Standards.GMS_SEARCH_10);
        if (cap == null) {
            throw new UnsupportedOperationException("service " + resourceID + " does not implement " + Standards.GMS_SEARCH_10);
        }
        try {
            if (!CredUtil.checkCredentials()) {
                throw new AccessControlException("delegated credentials not found");
            }
        }
        catch (CertificateExpiredException | CertificateNotYetValidException ex) {
            throw new AccessControlException("invalid delegated credentials: " + ex);
        }
        AuthMethod amc = AuthenticationUtil.getAuthMethodFromCredentials((Subject)cur);
        if (amc == null || AuthMethod.ANON.equals((Object)amc)) {
            throw new RuntimeException("BUG: subject has credentials but type unknown");
        }
        URI securityMethod = Standards.getSecurityMethod((AuthMethod)amc);
        Interface iface = cap.findInterface(securityMethod);
        if (iface == null) {
            throw new UnsupportedOperationException("service " + resourceID + " " + Standards.GMS_SEARCH_10 + " does not support auth via " + securityMethod);
        }
        URL queryURL = iface.getAccessURL().getURL();
        if (groupNames != null && !groupNames.isEmpty()) {
            StringBuilder sb = new StringBuilder(queryURL.toExternalForm());
            String sep = "?";
            for (String name : groupNames) {
                sb.append(sep).append("group=").append(name);
                sep = "&";
            }
            queryURL = new URL(sb.toString());
        }
        log.debug((Object)("queryURL: " + queryURL));
        TreeSet<GroupURI> ret = new TreeSet<GroupURI>();
        try {
            HttpGet query = new HttpGet(queryURL, true);
            query.prepare();
            InputStream istream = query.getInputStream();
            LineNumberReader r = new LineNumberReader(new InputStreamReader(istream));
            String line = r.readLine();
            while (line != null) {
                String name = line.trim();
                GroupURI g = new GroupURI(resourceID, name);
                ret.add(g);
                line = r.readLine();
            }
        }
        catch (ResourceAlreadyExistsException ex) {
            throw new RuntimeException("BUG: unexpected failure: " + ex, ex);
        }
        return ret;
    }

    private Map<URI, Set<String>> splitByResourceID(Set<GroupURI> uris) {
        TreeMap<URI, Set<String>> ret = new TreeMap<URI, Set<String>>();
        for (GroupURI u : uris) {
            TreeSet<String> cur = (TreeSet<String>)ret.get(u.getServiceID());
            if (cur == null) {
                cur = new TreeSet<String>();
                ret.put(u.getServiceID(), cur);
            }
            cur.add(u.getName());
        }
        return ret;
    }
}

