/*
 * Decompiled with CFR 0.152.
 */
package org.opencadc.gms;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;

public class GroupURI
implements Comparable<GroupURI> {
    private static final Logger log = Logger.getLogger(GroupURI.class);
    private URI uri;
    private static String GROUP_NAME_ERRORMSG = "Group Name contains illegal characters (only alphanumeric, '/', -', '.', '_', '~' allowed";

    public GroupURI(URI uri) throws IllegalArgumentException {
        if (uri == null) {
            throw new IllegalArgumentException("null URI");
        }
        if (uri.getScheme() == null || !"ivo".equals(uri.getScheme())) {
            throw new IllegalArgumentException("scheme must be 'ivo' in resourceID: " + uri);
        }
        if (uri.getAuthority() == null) {
            throw new IllegalArgumentException("authority is required in resourceID: " + uri);
        }
        if (uri.getPath() == null || uri.getPath().length() == 0) {
            throw new IllegalArgumentException("path is required in resourceID: " + uri);
        }
        if (uri.getFragment() != null) {
            throw new IllegalArgumentException("fragment not allowed in uri: " + uri);
        }
        if (uri.getQuery() == null) {
            throw new IllegalArgumentException("query (group name) required in uri: " + uri);
        }
        String name = uri.getQuery();
        if (!this.isValidGroupName(name)) {
            throw new IllegalArgumentException("invalid group name: " + name + " reason: " + GROUP_NAME_ERRORMSG);
        }
        this.uri = uri;
    }

    @Deprecated
    public GroupURI(String uri) throws IllegalArgumentException, URISyntaxException {
        this(new URI(uri));
    }

    public GroupURI(URI resourceID, String name) {
        if (resourceID == null) {
            throw new IllegalArgumentException("null GMS resourceID");
        }
        if (name == null) {
            throw new IllegalArgumentException("null group name");
        }
        if (resourceID.getScheme() == null || !"ivo".equals(resourceID.getScheme())) {
            throw new IllegalArgumentException("scheme must be 'ivo' in resourceID: " + resourceID);
        }
        if (resourceID.getAuthority() == null) {
            throw new IllegalArgumentException("authority is required in resourceID: " + resourceID);
        }
        if (resourceID.getPath() == null || resourceID.getPath().length() == 0) {
            throw new IllegalArgumentException("path is required in resourceID: " + resourceID);
        }
        if (resourceID.getQuery() != null) {
            throw new IllegalArgumentException("query not allowed in resourceID: " + resourceID);
        }
        if (resourceID.getFragment() != null) {
            throw new IllegalArgumentException("fragment not allowed in resourceID: " + resourceID);
        }
        if (!this.isValidGroupName(name)) {
            throw new IllegalArgumentException("invalid group name: " + name + " reason: " + GROUP_NAME_ERRORMSG);
        }
        this.uri = URI.create(resourceID.toASCIIString() + "?" + name);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof GroupURI) {
            GroupURI otherURI = (GroupURI)other;
            return this.uri.equals(otherURI.getURI());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(GroupURI t) {
        return this.uri.compareTo(t.uri);
    }

    public URI getURI() {
        return this.uri;
    }

    public String getName() {
        return this.uri.getQuery();
    }

    public URI getServiceID() {
        String serviceIDString = this.uri.getScheme() + "://" + this.uri.getAuthority() + this.uri.getPath();
        try {
            return new URI(serviceIDString);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("BUG: failed to create serviceID from GroupURI: " + this.uri, e);
        }
    }

    public String toString() {
        return this.uri.toASCIIString();
    }

    private boolean isValidGroupName(String groupName) {
        boolean isValid = false;
        if (groupName.matches("^[a-zA-Z0-9/_\\-\\.~]+$")) {
            isValid = true;
        }
        return isValid;
    }
}

