/*
 * Decompiled with CFR 0.152.
 */
package org.opencadc.auth;

import ca.nrc.cadc.auth.AuthMethod;
import ca.nrc.cadc.auth.AuthenticationUtil;
import ca.nrc.cadc.auth.AuthorizationToken;
import ca.nrc.cadc.auth.AuthorizationTokenPrincipal;
import ca.nrc.cadc.auth.HttpPrincipal;
import ca.nrc.cadc.auth.IdentityManager;
import ca.nrc.cadc.auth.NotAuthenticatedException;
import ca.nrc.cadc.auth.OpenIdPrincipal;
import ca.nrc.cadc.auth.PosixPrincipal;
import ca.nrc.cadc.net.HttpGet;
import ca.nrc.cadc.net.ResourceAlreadyExistsException;
import ca.nrc.cadc.net.ResourceNotFoundException;
import ca.nrc.cadc.reg.Standards;
import ca.nrc.cadc.reg.client.LocalAuthority;
import ca.nrc.cadc.reg.client.RegistryClient;
import ca.nrc.cadc.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.Key;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.VerificationJwkSelector;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.JoseException;
import org.jose4j.lang.UnresolvableKeyException;
import org.json.JSONObject;
import org.opencadc.auth.OIDCClient;
import org.opencadc.auth.OIDCProviderPubKey;
import org.opencadc.auth.PosixMapperClient;

public class StandardIdentityManager
implements IdentityManager {
    private static final Logger log = Logger.getLogger(StandardIdentityManager.class);
    private static final Set<URI> SEC_METHODS;
    private final RegistryClient reg = new RegistryClient();
    private final List<String> oidcDomains = new ArrayList<String>();
    private final PosixMapperClient pmc;
    OIDCClient oidcClient;
    private URI oidcScope;
    private static final String OID_OWNER_DELIM = " ";

    public StandardIdentityManager() {
        URI posixUserMap;
        LocalAuthority loc = new LocalAuthority();
        this.oidcClient = new OIDCClient(loc.getResourceID(Standards.SECURITY_METHOD_OPENID));
        URL u = this.oidcClient.getIssuerURL();
        this.oidcDomains.add(u.getHost());
        String host = this.getProviderHostname(loc, Standards.GMS_SEARCH_10);
        if (host != null) {
            this.oidcDomains.add(host);
        }
        if ((posixUserMap = loc.getResourceID(Standards.POSIX_USERMAP)) != null) {
            String pmcHost;
            if ("ivo".equals(posixUserMap.getScheme())) {
                this.pmc = new PosixMapperClient(posixUserMap);
                pmcHost = this.getProviderHostname(loc, Standards.POSIX_USERMAP);
            } else if ("https".equals(posixUserMap.getScheme()) || "http".equals(posixUserMap.getScheme())) {
                try {
                    URL url = posixUserMap.toURL();
                    pmcHost = url.getHost();
                    this.pmc = new PosixMapperClient(url);
                }
                catch (MalformedURLException ex) {
                    throw new RuntimeException("CONFIG: malformed posix mapper url: " + posixUserMap);
                }
            } else {
                throw new RuntimeException("CONFIG: unsupported posix-mapping identifier scheme: " + posixUserMap);
            }
            this.oidcDomains.add(pmcHost);
        } else {
            this.pmc = null;
        }
        for (String dom : this.oidcDomains) {
            log.debug((Object)("OIDC domain: " + dom));
        }
    }

    public Set<URI> getSecurityMethods() {
        return SEC_METHODS;
    }

    private String getProviderHostname(LocalAuthority loc, URI standardID) {
        try {
            URI resourceID = loc.getResourceID(standardID);
            if (resourceID != null) {
                URL srv = this.reg.getServiceURL(resourceID, standardID, AuthMethod.TOKEN);
                if (srv != null) {
                    return srv.getHost();
                }
                log.debug((Object)("found: " + resourceID + " not found: " + standardID + " + " + AuthMethod.TOKEN));
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        log.debug((Object)("not found: " + standardID));
        return null;
    }

    public Subject validate(Subject subject) throws NotAuthenticatedException {
        this.validateOidcAccessToken(subject);
        return subject;
    }

    public Subject augment(Subject subject) {
        boolean needAugment;
        boolean hasPP = !subject.getPrincipals(PosixPrincipal.class).isEmpty();
        boolean hasHP = !subject.getPrincipals(HttpPrincipal.class).isEmpty();
        boolean bl = needAugment = hasHP && !hasPP || hasPP && !hasHP;
        if (needAugment) {
            try {
                if (this.pmc != null) {
                    if (!subject.getPublicCredentials(AuthorizationToken.class).isEmpty()) {
                        return Subject.doAs(subject, () -> this.pmc.augment(subject));
                    }
                    Subject cur = AuthenticationUtil.getCurrentSubject();
                    if (cur != null && !cur.getPublicCredentials(AuthorizationToken.class).isEmpty()) {
                        return this.pmc.augment(subject);
                    }
                    throw new RuntimeException("BUG: did not call PosixMapperClient.augment(Subject): no credentials in caller subject");
                }
                log.debug((Object)("did not call PosixMapperClient.augment(Subject): no service configured to provide " + Standards.POSIX_USERMAP.toASCIIString()));
            }
            catch (ResourceAlreadyExistsException | ResourceNotFoundException | IOException | InterruptedException | PrivilegedActionException ex) {
                throw new RuntimeException("FAIL: PosixMapperClient.augment(Subject): " + ex.getMessage(), ex);
            }
            catch (RuntimeException ex) {
                if (ex.getMessage().startsWith("BUG:")) {
                    throw ex;
                }
                throw new RuntimeException("FAIL: PosixMapperClient.augment(Subject): " + ex.getMessage(), ex);
            }
        }
        return subject;
    }

    public Subject toSubject(Object owner) {
        Subject ret = new Subject();
        if (owner != null) {
            URL issuer;
            String[] openIDComponents;
            if (owner instanceof String) {
                openIDComponents = ((String)owner).split(OID_OWNER_DELIM);
                if (openIDComponents.length != 2) {
                    throw new RuntimeException("unexpected owner format: " + owner.getClass().getName() + " value: " + owner);
                }
                try {
                    issuer = new URL(openIDComponents[0]);
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("incorrect issuer format for owner: " + owner.getClass().getName() + " value: " + owner);
                }
            } else {
                throw new RuntimeException("unexpected owner type: " + owner.getClass().getName() + " value: " + owner);
            }
            OpenIdPrincipal p = new OpenIdPrincipal(issuer, openIDComponents[1]);
            Subject s = AuthenticationUtil.getCurrentSubject();
            if (s != null) {
                for (Principal cp : s.getPrincipals()) {
                    if (!AuthenticationUtil.equals((Principal)p, (Principal)cp)) continue;
                    log.debug((Object)("[cache hit] caller Subject matches " + p + ": " + s));
                    ret.getPrincipals().addAll(s.getPrincipals());
                    return ret;
                }
            }
            ret.getPrincipals().add((Principal)p);
        }
        return ret;
    }

    public Object toOwner(Subject subject) {
        Set<OpenIdPrincipal> ps = subject.getPrincipals(OpenIdPrincipal.class);
        if (ps.isEmpty()) {
            return null;
        }
        OpenIdPrincipal openIdPrincipal = ps.iterator().next();
        return openIdPrincipal.getIssuer().toExternalForm() + OID_OWNER_DELIM + openIdPrincipal.getName();
    }

    public String toDisplayString(Subject subject) {
        if (subject != null) {
            Set<HttpPrincipal> ps = subject.getPrincipals(HttpPrincipal.class);
            if (!ps.isEmpty()) {
                return ps.iterator().next().getName();
            }
            Set<Principal> ps2 = subject.getPrincipals();
            if (!ps2.isEmpty()) {
                return ps2.iterator().next().getName();
            }
        }
        return null;
    }

    private URI getJwtIssuer(String jwtToken) throws InvalidJwtException, MalformedClaimException, MalformedURLException {
        JwtConsumer firstPassJwtConsumer = new JwtConsumerBuilder().setSkipAllValidators().setDisableRequireSignature().setSkipSignatureVerification().build();
        JwtContext jwtContext = firstPassJwtConsumer.process(jwtToken);
        return URI.create(jwtContext.getJwtClaims().getIssuer());
    }

    private void validateOidcAccessToken(Subject s) {
        log.debug((Object)"validateOidcAccessToken - START");
        Set<AuthorizationTokenPrincipal> rawTokens = s.getPrincipals(AuthorizationTokenPrincipal.class);
        if (rawTokens.isEmpty()) {
            return;
        }
        if (rawTokens.size() > 1) {
            throw new NotAuthenticatedException("Bearer", NotAuthenticatedException.AuthError.INVALID_REQUEST, "Multiple authorization tokens not supported");
        }
        AuthorizationTokenPrincipal raw = rawTokens.iterator().next();
        if ("Authorization".equalsIgnoreCase(raw.getHeaderKey())) {
            String[] tval = raw.getHeaderValue().split(OID_OWNER_DELIM);
            if (tval.length == 2) {
                if ("Bearer".equalsIgnoreCase(tval[0])) {
                    this.validateToken(s, raw);
                }
            } else {
                throw new NotAuthenticatedException(raw.getHeaderValue(), NotAuthenticatedException.AuthError.INVALID_REQUEST, "BUG: invalid authorization " + raw.getHeaderValue());
            }
        }
    }

    private void validateToken(Subject s, AuthorizationTokenPrincipal raw) {
        String[] tval = raw.getHeaderValue().split(OID_OWNER_DELIM);
        String challengeType = tval[0];
        String credentials = tval[1];
        log.debug((Object)("challenge type: " + challengeType));
        log.debug((Object)("credentials: " + credentials));
        URI jwtIssuer = null;
        try {
            jwtIssuer = this.getJwtIssuer(credentials);
            if (!jwtIssuer.normalize().equals(this.oidcClient.issuer.normalize())) {
                throw new NotAuthenticatedException("Bearer", NotAuthenticatedException.AuthError.INVALID_REQUEST, "Token from untrusted issuer: " + jwtIssuer + " ignored");
            }
        }
        catch (MalformedURLException | MalformedClaimException | InvalidJwtException e) {
            log.debug((Object)"Cannot determine issuer from token", e);
        }
        List<Principal> validatedPrincipals = null;
        if (jwtIssuer != null) {
            try {
                validatedPrincipals = this.validateWithPubKey(jwtIssuer, challengeType, credentials);
            }
            catch (InvalidJwtException e) {
                String message = "Invalid JWT token";
                if (e.hasExpired()) {
                    message = "Token has expired";
                }
                throw new NotAuthenticatedException(challengeType, NotAuthenticatedException.AuthError.INVALID_TOKEN, message, (Throwable)e);
            }
            catch (MalformedURLException | MalformedClaimException e) {
                log.debug((Object)"Cannot validate token with issuer public key", e);
            }
        }
        if (validatedPrincipals == null) {
            try {
                validatedPrincipals = StandardIdentityManager.validateWithUserInfo(raw, this.oidcClient.getUserInfoEndpoint());
            }
            catch (NotAuthenticatedException | ResourceAlreadyExistsException | ResourceNotFoundException | IOException | InterruptedException e) {
                throw new NotAuthenticatedException(challengeType, NotAuthenticatedException.AuthError.INVALID_TOKEN, "Cannot validate token using user info endpoint", e);
            }
        }
        s.getPrincipals().remove(raw);
        for (Principal p : validatedPrincipals) {
            s.getPrincipals().add(p);
        }
        AuthorizationToken authToken = new AuthorizationToken(challengeType, credentials, this.oidcDomains, this.oidcScope);
        s.getPublicCredentials().add(authToken);
    }

    private List<Principal> validateWithPubKey(URI jwtIssuer, String challengeType, String credentials) throws MalformedURLException, InvalidJwtException, MalformedClaimException {
        VerificationKeyResolver httpsJwksKeyResolver = this.getHttpsJwksVerificationKeyResolver(jwtIssuer, challengeType);
        JwtConsumer jwtConsumer = new JwtConsumerBuilder().setRequireExpirationTime().setExpectedIssuers(true, new String[]{jwtIssuer.toString()}).setVerificationKeyResolver(httpsJwksKeyResolver).setSkipDefaultAudienceValidation().build();
        JwtClaims jwtClaims = jwtConsumer.processToClaims(credentials);
        log.debug((Object)("JWT validation succeeded! " + jwtClaims));
        String sub = (String)jwtClaims.getClaimValue("sub", String.class);
        ArrayList<Principal> result = new ArrayList<Principal>();
        OpenIdPrincipal oip = new OpenIdPrincipal(jwtIssuer.toURL(), sub);
        result.add((Principal)oip);
        if (jwtClaims.getClaimValueAsString("preferred_username") != null) {
            result.add((Principal)new HttpPrincipal(jwtClaims.getClaimValueAsString("preferred_username")));
        }
        log.debug((Object)("Validated user via issuer pub key: " + oip));
        return result;
    }

    private static List<Principal> validateWithUserInfo(AuthorizationTokenPrincipal raw, URL issuerURL) throws ResourceAlreadyExistsException, ResourceNotFoundException, IOException, InterruptedException {
        HttpGet get = new HttpGet(issuerURL, true);
        get.setRequestProperty("authorization", raw.getHeaderValue());
        get.prepare();
        InputStream istream = get.getInputStream();
        String str = StringUtil.readFromInputStream((InputStream)istream, (String)"UTF-8");
        JSONObject json = new JSONObject(str);
        String sub = json.getString("sub");
        String username = null;
        if (json.has("preferred_username")) {
            username = json.getString("preferred_username");
        } else if (json.has("name")) {
            username = json.getString("name");
        } else {
            log.debug((Object)("No username provided for OpenID identity issuer(" + issuerURL + "), sub(" + sub + ")"));
        }
        ArrayList<Principal> result = new ArrayList<Principal>();
        OpenIdPrincipal oip = new OpenIdPrincipal(issuerURL, sub);
        result.add((Principal)oip);
        if (username != null) {
            result.add((Principal)new HttpPrincipal(username));
        }
        log.debug((Object)("Validated user via user info endpoint: " + oip));
        return result;
    }

    private VerificationKeyResolver getHttpsJwksVerificationKeyResolver(URI jwtIssuer, String challengeType) throws MalformedURLException {
        JSONObject oidcConfig = this.getJsonObject(jwtIssuer, challengeType);
        if (oidcConfig.getString("jwks_uri") == null) {
            throw new NotAuthenticatedException(challengeType, NotAuthenticatedException.AuthError.INVALID_TOKEN, "BUG: Missing jwks_uri in OIDC .well-known/openid-configuration", null);
        }
        URL jwksUrl = URI.create(oidcConfig.getString("jwks_uri")).toURL();
        return new CacheVerificationKeyResolver(jwtIssuer, jwksUrl);
    }

    private JSONObject getJsonObject(URI jwtIssuer, String challengeType) {
        try {
            return this.oidcClient.getWellKnownJSON();
        }
        catch (IOException e) {
            throw new NotAuthenticatedException(challengeType, NotAuthenticatedException.AuthError.INVALID_TOKEN, "BUG: Cannot access OIDC .well-known/openid-configuration end point", (Throwable)e);
        }
    }

    static {
        TreeSet<URI> tmp = new TreeSet<URI>();
        tmp.add(Standards.SECURITY_METHOD_ANON);
        tmp.add(Standards.SECURITY_METHOD_TOKEN);
        SEC_METHODS = Collections.unmodifiableSet(tmp);
    }

    static class CacheVerificationKeyResolver
    implements VerificationKeyResolver {
        private final VerificationJwkSelector verificationJwkSelector = new VerificationJwkSelector();
        private boolean disambiguateWithVerifySignature;
        private final OIDCProviderPubKey oidcProviderPubKey;

        public CacheVerificationKeyResolver(URI jwtIssuer, URL jwksUrl) {
            this.oidcProviderPubKey = new OIDCProviderPubKey(jwtIssuer, jwksUrl);
        }

        public Key resolveKey(JsonWebSignature jsonWebSignature, List<JsonWebStructure> list) throws UnresolvableKeyException {
            JsonWebKeySet jwks = null;
            try {
                jwks = new JsonWebKeySet(this.oidcProviderPubKey.getCachingFile().getContent());
                List keys = jwks.getJsonWebKeys();
                JsonWebKey jwk = this.select(jsonWebSignature, keys);
                if (jwk == null) {
                    throw new UnresolvableKeyException("No key found for signature");
                }
                return jwk.getKey();
            }
            catch (IOException | JoseException e) {
                throw new UnresolvableKeyException("Bug: Error selecting key", e);
            }
        }

        protected JsonWebKey select(JsonWebSignature jws, List<JsonWebKey> jsonWebKeys) throws JoseException {
            return this.disambiguateWithVerifySignature ? this.verificationJwkSelector.selectWithVerifySignatureDisambiguate(jws, jsonWebKeys) : this.verificationJwkSelector.select(jws, jsonWebKeys);
        }

        public void setDisambiguateWithVerifySignature(boolean disambiguateWithVerifySignature) {
            this.disambiguateWithVerifySignature = disambiguateWithVerifySignature;
        }
    }
}

