/*
 * Decompiled with CFR 0.152.
 */
package org.opencadc.auth;

import ca.nrc.cadc.auth.AuthMethod;
import ca.nrc.cadc.auth.AuthenticationUtil;
import ca.nrc.cadc.auth.HttpPrincipal;
import ca.nrc.cadc.auth.PosixPrincipal;
import ca.nrc.cadc.io.ResourceIterator;
import ca.nrc.cadc.net.HttpGet;
import ca.nrc.cadc.net.ResourceAlreadyExistsException;
import ca.nrc.cadc.net.ResourceNotFoundException;
import ca.nrc.cadc.reg.Capabilities;
import ca.nrc.cadc.reg.CapabilitiesReader;
import ca.nrc.cadc.reg.Capability;
import ca.nrc.cadc.reg.Interface;
import ca.nrc.cadc.reg.Standards;
import ca.nrc.cadc.reg.client.RegistryClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.opencadc.auth.PosixGroup;
import org.opencadc.gms.GroupURI;

public class PosixMapperClient {
    private static final Logger log = Logger.getLogger(PosixMapperClient.class);
    private final String service;
    private final Capabilities capabilities;
    private final TSVPosixGroupParser tsvPosixGroupParser = new TSVPosixGroupParser();
    private final TSVPosixPrincipalParser tsvPosixPrincipalParser = new TSVPosixPrincipalParser();

    public PosixMapperClient(URI resourceID) {
        if (resourceID == null) {
            throw new IllegalArgumentException("resourceID cannot be null");
        }
        this.service = resourceID.toASCIIString();
        try {
            RegistryClient regClient = new RegistryClient();
            regClient.setConnectionTimeout(6000);
            regClient.setReadTimeout(12000);
            this.capabilities = regClient.getCapabilities(resourceID);
        }
        catch (Exception ex) {
            throw new RuntimeException("failed to read capabilities for " + this.service, ex);
        }
    }

    public PosixMapperClient(URL baseURL) {
        if (baseURL == null) {
            throw new IllegalArgumentException("baseURL cannot be null");
        }
        this.service = baseURL.toExternalForm();
        try {
            URL capURL = new URL(baseURL.toExternalForm() + "/capabilities");
            HttpGet get = new HttpGet(capURL, true);
            get.setConnectionTimeout(6000);
            get.setReadTimeout(12000);
            get.prepare();
            CapabilitiesReader r = new CapabilitiesReader();
            this.capabilities = r.read(get.getInputStream());
        }
        catch (ResourceAlreadyExistsException bug) {
            throw new RuntimeException("BUG: unexpected fail", bug);
        }
        catch (ResourceNotFoundException | IOException | InterruptedException ex) {
            throw new RuntimeException("failed to read capabilities from " + this.service, ex);
        }
    }

    public Subject augment(Subject subject) throws IOException, InterruptedException, ResourceNotFoundException, ResourceAlreadyExistsException {
        if (subject == null) {
            throw new IllegalArgumentException("subject cannot be null");
        }
        Set<PosixPrincipal> posixPrincipals = subject.getPrincipals(PosixPrincipal.class);
        Set<HttpPrincipal> httpPrincipals = subject.getPrincipals(HttpPrincipal.class);
        if (!posixPrincipals.isEmpty() && !httpPrincipals.isEmpty()) {
            return subject;
        }
        if (posixPrincipals.isEmpty() && httpPrincipals.isEmpty()) {
            throw new IllegalArgumentException("Subject must contain either a HttpPrincipal or a PosixPrincipal");
        }
        URL userMapURL = this.getServiceURL(Standards.POSIX_USERMAP);
        String user = null;
        Integer uid = null;
        if (!posixPrincipals.isEmpty()) {
            uid = posixPrincipals.iterator().next().getUidNumber();
        } else {
            user = httpPrincipals.iterator().next().getName();
        }
        StringBuilder query = new StringBuilder(userMapURL.toExternalForm());
        query.append("?");
        if (user != null) {
            query.append("user=").append(user);
        } else {
            query.append("uid=").append(uid);
        }
        URL queryURL = new URL(query.toString());
        HttpGet get = new HttpGet(queryURL, true);
        get.setConnectionTimeout(6000);
        get.setReadTimeout(30000);
        get.setRequestProperty("accept", "text/tab-separated-values");
        get.prepare();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(get.getInputStream()));){
            String line = reader.readLine();
            PosixPrincipal posixPrincipal = this.tsvPosixPrincipalParser.parse(line);
            HashSet<Object> principals = new HashSet<Object>();
            principals.add(posixPrincipal);
            principals.add(new HttpPrincipal(posixPrincipal.username));
            for (Principal p : subject.getPrincipals()) {
                if (p instanceof HttpPrincipal || p instanceof PosixPrincipal) continue;
                principals.add(p);
            }
            Subject subject2 = new Subject(false, principals, subject.getPublicCredentials(), subject.getPrivateCredentials());
            return subject2;
        }
    }

    public List<PosixGroup> getGID(List<GroupURI> groups) throws IOException, InterruptedException, ResourceNotFoundException, ResourceAlreadyExistsException {
        if (groups == null) {
            throw new IllegalArgumentException("groups cannot be null");
        }
        return this.getPosixGroups(groups, null);
    }

    public List<PosixGroup> getURI(List<Integer> groups) throws IOException, InterruptedException, ResourceNotFoundException, ResourceAlreadyExistsException {
        if (groups == null) {
            throw new IllegalArgumentException("groups cannot be null");
        }
        return this.getPosixGroups(null, groups);
    }

    public ResourceIterator<PosixPrincipal> getUserMap() throws IOException, ResourceNotFoundException, ResourceAlreadyExistsException, InterruptedException {
        URL userMapURL = this.getServiceURL(Standards.POSIX_USERMAP);
        final HttpGet get = new HttpGet(userMapURL, true);
        get.setConnectionTimeout(6000);
        get.setReadTimeout(30000);
        get.setRequestProperty("accept", "text/tab-separated-values");
        get.prepare();
        return new ResourceIterator<PosixPrincipal>(){
            private final BufferedReader reader;
            private String line;
            {
                this.reader = new BufferedReader(new InputStreamReader(get.getInputStream()));
            }

            public boolean hasNext() {
                try {
                    this.line = this.reader.readLine();
                    return this.line != null;
                }
                catch (IOException ioException) {
                    throw new RuntimeException(ioException.getMessage(), ioException);
                }
            }

            public PosixPrincipal next() {
                PosixPrincipal nextPrincipal = PosixMapperClient.this.tsvPosixPrincipalParser.parse(this.line);
                this.line = null;
                return nextPrincipal;
            }

            public void close() throws IOException {
                this.reader.close();
            }
        };
    }

    public ResourceIterator<PosixGroup> getGroupMap() throws IOException, ResourceNotFoundException, ResourceAlreadyExistsException, InterruptedException {
        URL userMapURL = this.getServiceURL(Standards.POSIX_GROUPMAP);
        final HttpGet get = new HttpGet(userMapURL, true);
        get.setConnectionTimeout(6000);
        get.setReadTimeout(30000);
        get.setRequestProperty("accept", "text/tab-separated-values");
        get.prepare();
        return new ResourceIterator<PosixGroup>(){
            private final BufferedReader reader;
            private String line;
            {
                this.reader = new BufferedReader(new InputStreamReader(get.getInputStream()));
            }

            public boolean hasNext() {
                try {
                    this.line = this.reader.readLine();
                    return this.line != null;
                }
                catch (IOException ioException) {
                    throw new RuntimeException(ioException.getMessage(), ioException);
                }
            }

            public PosixGroup next() {
                PosixGroup posixGroup = PosixMapperClient.this.tsvPosixGroupParser.parse(this.line);
                this.line = null;
                return posixGroup;
            }

            public void close() throws IOException {
                this.reader.close();
            }
        };
    }

    private List<PosixGroup> getPosixGroups(List<GroupURI> groupURIs, List<Integer> groupGIDs) throws IOException, InterruptedException, ResourceNotFoundException, ResourceAlreadyExistsException {
        URL groupMapURL = this.getServiceURL(Standards.POSIX_GROUPMAP);
        StringBuilder query = new StringBuilder(groupMapURL.toExternalForm());
        String sep = "?";
        if (groupURIs != null) {
            for (GroupURI groupURI : groupURIs) {
                query.append(sep).append("group=").append(groupURI.getURI().toASCIIString());
                sep = "&";
            }
        } else {
            for (Integer gid : groupGIDs) {
                query.append(sep).append("gid=").append(gid);
                sep = "&";
            }
        }
        URL queryURL = new URL(query.toString());
        HttpGet get = new HttpGet(queryURL, true);
        get.setConnectionTimeout(6000);
        get.setReadTimeout(30000);
        get.setRequestProperty("accept", "text/tab-separated-values");
        get.prepare();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(get.getInputStream()));){
            ArrayList<PosixGroup> posixGroups = new ArrayList<PosixGroup>();
            while (reader.ready()) {
                String line = reader.readLine();
                posixGroups.add(this.tsvPosixGroupParser.parse(line));
            }
            ArrayList<PosixGroup> arrayList = posixGroups;
            return arrayList;
        }
    }

    private URL getServiceURL(URI standardID) {
        if (this.capabilities == null) {
            throw new RuntimeException("BUG: capabilities not found and went undetected");
        }
        Capability capability = this.capabilities.findCapability(standardID);
        if (capability == null) {
            throw new UnsupportedOperationException(String.format("service %s does not implement %s", this.service, standardID));
        }
        Subject subject = AuthenticationUtil.getCurrentSubject();
        AuthMethod amc = AuthenticationUtil.getAuthMethodFromCredentials((Subject)subject);
        URI securityMethod = Standards.getSecurityMethod((AuthMethod)amc);
        Interface iface = capability.findInterface(securityMethod);
        if (iface == null) {
            throw new UnsupportedOperationException(String.format("service %s %s does not support auth via %s", this.service, standardID, securityMethod));
        }
        return iface.getAccessURL().getURL();
    }

    private static class TSVPosixPrincipalParser {
        private TSVPosixPrincipalParser() {
        }

        final PosixPrincipal parse(String line) {
            log.debug((Object)("line: " + line));
            String[] tokens = line.split("\\s+");
            if (tokens.length != 3) {
                throw new IllegalStateException(String.format("error parsing query results, expected 3 values, found %s: %s", tokens.length, line));
            }
            PosixPrincipal posixPrincipal = new PosixPrincipal(Integer.parseInt(tokens[1]));
            posixPrincipal.username = tokens[0];
            posixPrincipal.defaultGroup = Integer.parseInt(tokens[2]);
            return posixPrincipal;
        }
    }

    private static class TSVPosixGroupParser {
        private TSVPosixGroupParser() {
        }

        final PosixGroup parse(String line) {
            log.debug((Object)("line: " + line));
            String[] tokens = line.split("\\s+");
            if (tokens.length != 2) {
                throw new IllegalStateException(String.format("error parsing query results, expected 2 values, found %s: %s", tokens.length, line));
            }
            GroupURI groupURI = new GroupURI(URI.create(tokens[0]));
            Integer gid = Integer.parseInt(tokens[1]);
            return new PosixGroup(gid, groupURI);
        }
    }
}

