/*
 * Decompiled with CFR 0.152.
 */
package org.opencadc.auth;

import ca.nrc.cadc.reg.client.CachingFile;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.log4j.Logger;
import org.opencadc.auth.OIDCClient;

public class OIDCProviderPubKey {
    private static final Logger log = Logger.getLogger(OIDCProviderPubKey.class);
    private URL jwksUrl;
    final URI issuer;

    public OIDCProviderPubKey(URI issuer, URL jwksUrl) {
        if (issuer == null) {
            throw new IllegalStateException("OIDC Issuer URI is required.");
        }
        if (jwksUrl == null) {
            throw new IllegalStateException("JWKS URI is required.");
        }
        this.issuer = issuer;
        this.jwksUrl = jwksUrl;
    }

    public CachingFile getCachingFile() {
        return new CachingFile(this.getCachedFile(), this.jwksUrl);
    }

    private File getCachedFile() {
        Path baseCacheDir = OIDCClient.getBaseCacheDirectory();
        String issuerAuthority = this.issuer.getAuthority();
        Path resourceCacheDir = Paths.get(baseCacheDir.toString(), issuerAuthority);
        Path path = Paths.get(resourceCacheDir.toString(), this.issuer.getPath(), "jwks.json");
        log.debug((Object)("Caching file [" + path + "] in dir [" + resourceCacheDir + "]"));
        return path.toFile();
    }
}

