/*
 * Decompiled with CFR 0.152.
 */
package org.opencadc.auth;

import ca.nrc.cadc.reg.client.CachingFile;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.log4j.Logger;
import org.opencadc.auth.OIDCClient;

public class OIDCDiscovery {
    private static final Logger log = Logger.getLogger(OIDCDiscovery.class);
    private static final String WELL_KNOWN_ENDPOINT = "/.well-known/openid-configuration";
    final URI issuer;

    public OIDCDiscovery(URI issuer) {
        if (issuer == null) {
            throw new IllegalStateException("OIDC Issuer URI is required.");
        }
        this.issuer = issuer;
    }

    public CachingFile getCachingFile() throws MalformedURLException {
        return new CachingFile(this.getCachedFile(), new URL(this.issuer.toURL().toExternalForm() + WELL_KNOWN_ENDPOINT));
    }

    private File getCachedFile() {
        Path baseCacheDir = OIDCClient.getBaseCacheDirectory();
        String issuerAuthority = this.issuer.getAuthority();
        Path resourceCacheDir = Paths.get(baseCacheDir.toString(), issuerAuthority);
        Path path = Paths.get(resourceCacheDir.toString(), this.issuer.getPath(), WELL_KNOWN_ENDPOINT);
        log.debug((Object)("Caching file [" + path + "] in dir [" + resourceCacheDir + "]"));
        return path.toFile();
    }
}

