/*
 * Decompiled with CFR 0.152.
 */
package org.opencadc.auth;

import ca.nrc.cadc.reg.Standards;
import ca.nrc.cadc.reg.client.CachingFile;
import ca.nrc.cadc.util.InvalidConfigException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.json.JSONObject;
import org.opencadc.auth.OIDCDiscovery;

class OIDCClient {
    private static final String USERINFO_ENDPOINT_KEY = "userinfo_endpoint";
    private static final String ISSUER_LOOKUP_KEY = Standards.SECURITY_METHOD_OPENID.toASCIIString();
    private static final String CACHE_DIRECTORY_NAME = "cadc-gms-1.0";
    final OIDCDiscovery oidcDiscovery;
    final URI issuer;

    public OIDCClient(URI issuer) {
        if (issuer == null) {
            throw new IllegalStateException("OpenID Connect Issuer URI is required.");
        }
        this.issuer = issuer;
        this.oidcDiscovery = new OIDCDiscovery(this.issuer);
    }

    URL getIssuerURL() {
        try {
            return this.issuer.toURL();
        }
        catch (MalformedURLException ex) {
            throw new InvalidConfigException("found " + ISSUER_LOOKUP_KEY + " = " + this.issuer + " - expected valid URL", (Throwable)ex);
        }
    }

    JSONObject getWellKnownJSON() throws IOException {
        CachingFile cachingFile = this.oidcDiscovery.getCachingFile();
        return new JSONObject(cachingFile.getContent());
    }

    URL getUserInfoEndpoint() {
        try {
            JSONObject jsonObject = this.getWellKnownJSON();
            String userInfoEndpointString = jsonObject.getString(USERINFO_ENDPOINT_KEY);
            return new URL(userInfoEndpointString);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("BUG: failed to create valid oidc userinfo url", malformedURLException);
        }
        catch (IOException ioException) {
            throw new IllegalStateException(ioException.getMessage(), ioException);
        }
    }

    static Path getBaseCacheDirectory() {
        String tmpDir = System.getProperty("java.io.tmpdir");
        String userName = System.getProperty("user.name");
        if (tmpDir == null) {
            throw new RuntimeException("No tmp system dir defined.");
        }
        Path baseCacheDir = userName == null ? Paths.get(tmpDir, CACHE_DIRECTORY_NAME) : Paths.get(tmpDir, userName, CACHE_DIRECTORY_NAME);
        return baseCacheDir;
    }
}

