/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.cred.util;

import ca.nrc.cadc.auth.AuthenticationUtil;
import ca.nrc.cadc.auth.HttpPrincipal;
import ca.nrc.cadc.auth.SSLUtil;
import ca.nrc.cadc.auth.ServletPrincipalExtractor;
import ca.nrc.cadc.auth.X509CertificateChain;
import ca.nrc.cadc.log.ServletLogInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Principal;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.x500.X500Principal;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class CredInjectionServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger(CredInjectionServlet.class);
    private static final String AUTHORIZED_DN = "authorized_dn";
    private static final String AUTHORIZED_UID = "authorized_uid";
    private static final double MAX_CERT_SIZE_BYTES = Math.pow(2.0, 16.0);
    private String authorizedDN;
    private String authorizedUID;

    public void init(ServletConfig config) throws ServletException {
        this.authorizedDN = config.getInitParameter(AUTHORIZED_DN);
        this.authorizedDN = this.authorizedDN.replace("\"", "");
        this.authorizedDN = AuthenticationUtil.canonizeDistinguishedName((String)this.authorizedDN);
        this.authorizedUID = config.getInitParameter(AUTHORIZED_UID);
        this.authorizedUID = this.authorizedUID.replace("\"", "");
        if (this.authorizedDN == null && this.authorizedUID == null) {
            throw new ExceptionInInitializerError("No authorized users configured to inject credentials.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        block14: {
            ServletLogInfo logInfo = new ServletLogInfo(request);
            long start = System.currentTimeMillis();
            log.info((Object)logInfo.start());
            try {
                ServletPrincipalExtractor principalExtractor = new ServletPrincipalExtractor(request);
                Set principals = principalExtractor.getPrincipals();
                if (principals == null || principals.size() == 0) {
                    response.setStatus(401);
                    return;
                }
                boolean isAuthorized = false;
                for (Principal p : principals) {
                    String uid;
                    String dn;
                    if (p instanceof X500Principal && (dn = AuthenticationUtil.canonizeDistinguishedName((String)p.getName())).equals(this.authorizedDN)) {
                        isAuthorized = true;
                    }
                    if (!(p instanceof HttpPrincipal) || !(uid = p.getName()).equals(this.authorizedUID)) continue;
                    isAuthorized = true;
                }
                if (!isAuthorized) {
                    response.setStatus(403);
                    return;
                }
                X509CertificateChain chain = this.uploadCert(request);
                this.storeInJNDI(chain);
            }
            catch (Throwable t) {
                String message = "Unexpected error: " + t.getMessage();
                log.error((Object)message, t);
                logInfo.setSuccess(false);
                logInfo.setMessage(message);
                if (!response.isCommitted()) {
                    try {
                        response.getWriter().write(message);
                    }
                    catch (IOException e) {
                        log.warn((Object)"Failed to write message to response", (Throwable)e);
                    }
                    response.setStatus(500);
                    break block14;
                }
                log.warn((Object)"Response already committed.");
            }
            finally {
                long elapsed = System.currentTimeMillis() - start;
                logInfo.setElapsedTime(Long.valueOf(elapsed));
                log.info((Object)logInfo.end());
            }
        }
    }

    private X509CertificateChain uploadCert(HttpServletRequest request) throws Exception {
        int bytesRead;
        byte[] buff = new byte[1024];
        ServletInputStream in = request.getInputStream();
        int totalBytesRead = 0;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((bytesRead = in.read(buff, 0, 1024)) > 0) {
            if ((double)(totalBytesRead += bytesRead) > MAX_CERT_SIZE_BYTES) {
                throw new IllegalArgumentException("Certificate chain too big.");
            }
            out.write(buff, 0, bytesRead);
        }
        out.flush();
        log.debug((Object)("Uploaded cert: " + out.toString()));
        return SSLUtil.readPemCertificateAndKey((byte[])out.toByteArray());
    }

    private void storeInJNDI(X509CertificateChain chain) throws NamingException {
        InitialContext ic = new InitialContext();
        try {
            ic.unbind("servops-cert");
            log.debug((Object)"Unbound previously bound certificate.");
        }
        catch (NamingException e) {
            log.debug((Object)"No certificate to unbind");
        }
        ic.bind("servops-cert", (Object)chain);
        log.debug((Object)"Stored certificate in JNDI.");
    }
}

