/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.cred.client;

import ca.nrc.cadc.auth.AuthenticationUtil;
import ca.nrc.cadc.auth.AuthorizationToken;
import ca.nrc.cadc.auth.SSLUtil;
import ca.nrc.cadc.auth.SSOCookieCredential;
import ca.nrc.cadc.auth.X509CertificateChain;
import ca.nrc.cadc.cred.client.CredClient;
import ca.nrc.cadc.reg.Standards;
import ca.nrc.cadc.reg.client.LocalAuthority;
import java.io.File;
import java.net.URI;
import java.security.AccessControlException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;

public class CredUtil {
    private static final Logger log = Logger.getLogger(CredUtil.class);
    public static final double PROXY_CERT_DURATION = 0.1;
    public static final String SERVOPS_JNDI_NAME = "servops-cert";

    private CredUtil() {
    }

    public static Subject createOpsSubject() {
        Subject s = CredUtil.createServopsSubjectFromJNDI();
        log.debug((Object)("servops subject from JNDI: " + s));
        if (s == null) {
            s = CredUtil.createServopsSubjectFromFile();
            log.debug((Object)("servops subject from disk: " + s));
        }
        if (s != null) {
            X509CertificateChain ops = X509CertificateChain.findPrivateKeyChain(s.getPublicCredentials());
            try {
                ops.getChain()[0].checkValidity();
            }
            catch (Exception ex) {
                throw new RuntimeException("CONFIG: servops certificate is invalid", ex);
            }
            return s;
        }
        throw new IllegalStateException("servops.pem not found in JNDI or on disk.");
    }

    private static Subject createServopsSubjectFromJNDI() {
        try {
            InitialContext ic = new InitialContext();
            Object entry = ic.lookup(SERVOPS_JNDI_NAME);
            if (entry == null) {
                return null;
            }
            X509CertificateChain chain = (X509CertificateChain)entry;
            return AuthenticationUtil.getSubject((X509CertificateChain)chain);
        }
        catch (NameNotFoundException e) {
            return null;
        }
        catch (NamingException e) {
            log.warn((Object)"Unexpected JNDI exception.", (Throwable)e);
            return null;
        }
    }

    private static Subject createServopsSubjectFromFile() {
        File pemFile = new File(System.getProperty("user.home") + "/.ssl/cadcproxy.pem");
        return SSLUtil.createSubject((File)pemFile);
    }

    public static boolean checkCredentials() throws AccessControlException, CertificateExpiredException, CertificateNotYetValidException {
        return CredUtil.checkCredentials(AuthenticationUtil.getCurrentSubject());
    }

    public static boolean checkCredentials(final Subject subject) throws AccessControlException, CertificateExpiredException, CertificateNotYetValidException {
        URI credURI;
        if (subject == null) {
            return false;
        }
        log.debug((Object)"check for valid cookie credentials...");
        Set<SSOCookieCredential> cookieCreds = subject.getPublicCredentials(SSOCookieCredential.class);
        for (SSOCookieCredential nextCookie : cookieCreds) {
            log.debug((Object)("Checking cookie credential: " + nextCookie));
            if (nextCookie.isExpired()) continue;
            return true;
        }
        log.debug((Object)"... no valid cookies");
        log.debug((Object)"check for auth tokens...");
        Set<AuthorizationToken> tokens = subject.getPublicCredentials(AuthorizationToken.class);
        if (!tokens.isEmpty()) {
            return true;
        }
        log.debug((Object)"... no tokens");
        log.debug((Object)"check for a valid X509CertificateChain...");
        X509CertificateChain privateKeyChain = X509CertificateChain.findPrivateKeyChain(subject.getPublicCredentials());
        if (privateKeyChain != null) {
            try {
                privateKeyChain.getChain()[0].checkValidity();
                return true;
            }
            catch (CertificateException ex) {
                log.debug((Object)"invalid X509CertificateChain: removing");
                privateKeyChain = null;
            }
        }
        log.debug((Object)"... no valid X509CertificateChain");
        if (subject.getPrincipals().isEmpty()) {
            log.debug((Object)"no principals: return false");
            return false;
        }
        LocalAuthority loc = new LocalAuthority();
        try {
            credURI = loc.getServiceURI(Standards.CRED_PROXY_10.toASCIIString());
        }
        catch (NoSuchElementException ex) {
            log.debug((Object)("checkCredentials: no local CDP service " + Standards.CRED_PROXY_10 + " in LocalAuthority"));
            return false;
        }
        if (credURI == null) {
            log.debug((Object)("checkCredentials: no local CDP service " + Standards.CRED_PROXY_10 + " in LocalAuthority"));
            return false;
        }
        final CredClient cred = new CredClient(credURI);
        Subject opsSubject = CredUtil.createOpsSubject();
        try {
            privateKeyChain = Subject.doAs(opsSubject, new PrivilegedExceptionAction<X509CertificateChain>(){

                @Override
                public X509CertificateChain run() throws Exception {
                    return cred.getProxyCertificate(subject, 0.1);
                }
            });
        }
        catch (PrivilegedActionException ex) {
            throw new RuntimeException("CredClient.getProxyCertficate failed", ex.getException());
        }
        if (privateKeyChain == null) {
            throw new AccessControlException("credential service did not return a delegated certificate");
        }
        privateKeyChain.getChain()[0].checkValidity();
        Iterator<Object> iter = subject.getPublicCredentials().iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof X509CertificateChain)) continue;
            iter.remove();
        }
        subject.getPublicCredentials().add(privateKeyChain);
        return true;
    }
}

