/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.cred.client;

import ca.nrc.cadc.auth.AuthMethod;
import ca.nrc.cadc.auth.AuthenticationUtil;
import ca.nrc.cadc.auth.HttpPrincipal;
import ca.nrc.cadc.auth.SSLUtil;
import ca.nrc.cadc.auth.X509CertificateChain;
import ca.nrc.cadc.cred.CertUtil;
import ca.nrc.cadc.net.HttpGet;
import ca.nrc.cadc.net.NetUtil;
import ca.nrc.cadc.net.ResourceNotFoundException;
import ca.nrc.cadc.profiler.Profiler;
import ca.nrc.cadc.reg.Standards;
import ca.nrc.cadc.reg.client.RegistryClient;
import ca.nrc.cadc.util.Base64;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;

public class CredClient {
    private static Logger LOGGER = Logger.getLogger(CredClient.class);
    private URI serviceID;
    private RegistryClient reg;

    public CredClient(URI serviceID) {
        if (serviceID == null) {
            throw new IllegalArgumentException("invalid serviceID: " + serviceID);
        }
        if (serviceID.getFragment() != null) {
            throw new IllegalArgumentException("invalid serviceID (fragment not allowed): " + serviceID);
        }
        this.serviceID = serviceID;
    }

    String getServiceBaseURL() {
        URL u = this.getRegistryClient().getServiceURL(this.serviceID, Standards.VOSI_CAPABILITIES, AuthMethod.ANON);
        String ret = u.toExternalForm().replace("/capabilities", "");
        return ret;
    }

    public X509CertificateChain getProxyCertificate(Subject subject, double daysValid) throws AccessControlException, CertificateException, IOException, ResourceNotFoundException {
        Set<Principal> principals = subject.getPrincipals();
        X500Principal x500Principal = null;
        HttpPrincipal httpPrincipal = null;
        for (Principal principal : principals) {
            if (principal instanceof X500Principal && x500Principal == null) {
                x500Principal = (X500Principal)principal;
                continue;
            }
            if (!(principal instanceof HttpPrincipal) || httpPrincipal != null) continue;
            httpPrincipal = (HttpPrincipal)principal;
        }
        StringBuilder path = new StringBuilder();
        if (x500Principal != null) {
            String dn = AuthenticationUtil.canonizeDistinguishedName((String)x500Principal.getName());
            path.append("/dn/").append(NetUtil.encode((String)dn));
        } else if (httpPrincipal != null) {
            path.append("/userid/").append(httpPrincipal.getName());
        } else {
            throw new UnsupportedOperationException("current subject lacks supported principal type");
        }
        if (daysValid > 0.0) {
            path.append("?daysValid=").append(String.valueOf(daysValid));
        }
        LOGGER.debug((Object)("serviceID: " + this.serviceID));
        URL credUrl = this.getRegistryClient().getServiceURL(this.serviceID, Standards.CRED_PROXY_10, AuthMethod.CERT);
        if (credUrl == null) {
            throw new RuntimeException("lookup failed: " + this.serviceID + " + " + Standards.CRED_PROXY_10 + " + " + AuthMethod.CERT);
        }
        URL url = new URL(credUrl.toExternalForm() + path.toString());
        LOGGER.debug((Object)("getCertficate: " + url.toString()));
        return this.downloadCertificate(url);
    }

    public void delegate(double days) throws MalformedURLException, IOException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, CertificateEncodingException, CertificateParsingException, CertificateExpiredException, CertificateNotYetValidException, ResourceNotFoundException {
        this.delegate(null, days);
    }

    public void delegate(X500Principal userDN, double days) throws MalformedURLException, IOException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, CertificateEncodingException, CertificateParsingException, CertificateExpiredException, CertificateNotYetValidException, ResourceNotFoundException {
        URL credUrl;
        StringBuilder resourcePath = new StringBuilder(64);
        if (userDN != null) {
            resourcePath.append("?DN=");
            resourcePath.append(URLEncoder.encode(userDN.getName(), "UTF-8"));
        }
        URL resourceURL = credUrl = this.getRegistryClient().getServiceURL(this.serviceID, Standards.CRED_DELEGATE_10, AuthMethod.CERT);
        if (userDN != null) {
            resourceURL = new URL(credUrl.toExternalForm() + "/" + resourcePath.toString());
        }
        LOGGER.debug((Object)("delegate(), URL=" + resourceURL));
        HttpsURLConnection connection = this.openConnection(resourceURL);
        connection.setRequestMethod("POST");
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        connection.connect();
        String responseMessage = connection.getResponseMessage();
        int responseCode = connection.getResponseCode();
        LOGGER.debug((Object)("create step in delegate(), response code: " + responseCode));
        LOGGER.debug((Object)("create step in delegate(), response message: " + responseMessage));
        switch (responseCode) {
            case 201: {
                String location = connection.getHeaderField("Location");
                int sec = (int)days * 24 * 60 * 60;
                String csr = this.getEncodedCSR(location, userDN);
                PKCS10CertificationRequest req = CredClient.readCSR(csr.getBytes());
                X509Certificate cert = this.generateV3Certificate(req, sec);
                LOGGER.debug((Object)("generated: " + cert.getSubjectDN() + " issuer: " + cert.getIssuerDN()));
                X509Certificate[] chain = this.createProxyCertChain(cert);
                this.putSignedCert(location, chain, userDN);
                break;
            }
            case 401: {
                throw new AccessControlException(responseMessage);
            }
            case 404: {
                throw new ResourceNotFoundException(responseMessage);
            }
            case 200: 
            case 400: 
            case 409: {
                throw new IllegalArgumentException(responseMessage);
            }
            default: {
                throw new RuntimeException("Unexpected failure mode: " + responseMessage + "(" + responseCode + ")");
            }
        }
    }

    public String createResoure(X500Principal userDN) throws IOException, ResourceNotFoundException {
        URL credUrl;
        StringBuilder resourcePath = new StringBuilder(64);
        if (userDN != null) {
            resourcePath.append("?DN=");
            resourcePath.append(URLEncoder.encode(userDN.getName(), "UTF-8"));
        }
        URL resourceURL = credUrl = this.getRegistryClient().getServiceURL(this.serviceID, Standards.CRED_DELEGATE_10, AuthMethod.CERT);
        if (userDN != null) {
            resourceURL = new URL(credUrl.toExternalForm() + "/" + resourcePath.toString());
        }
        LOGGER.debug((Object)("delegate(), URL=" + resourceURL));
        HttpsURLConnection connection = this.openConnection(resourceURL);
        connection.setRequestMethod("POST");
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        connection.connect();
        String responseMessage = connection.getResponseMessage();
        int responseCode = connection.getResponseCode();
        LOGGER.debug((Object)("create step in delegate(), response code: " + responseCode));
        LOGGER.debug((Object)("create step in delegate(), response message: " + responseMessage));
        switch (responseCode) {
            case 201: {
                return connection.getHeaderField("Location");
            }
            case 200: 
            case 404: 
            case 409: {
                throw new ResourceNotFoundException(responseMessage);
            }
            case 400: {
                throw new IllegalArgumentException(responseMessage);
            }
            case 403: {
                throw new AccessControlException(responseMessage);
            }
        }
        throw new RuntimeException("Unexpected failure mode: " + responseMessage + "(" + responseCode + ")");
    }

    public void deleteResource(X500Principal userDN) throws IOException, CertificateException, ResourceNotFoundException {
        String location = this.getLocation(userDN);
        StringBuilder resourcePath = new StringBuilder(64);
        resourcePath.append(location);
        if (userDN != null) {
            resourcePath.append("?DN=");
            resourcePath.append(URLEncoder.encode(userDN.getName(), "UTF-8"));
        }
        URL resourceURL = new URL(resourcePath.toString());
        LOGGER.debug((Object)("delegate(), URL=" + resourceURL));
        HttpsURLConnection connection = this.openConnection(resourceURL);
        connection.setRequestMethod("DELETE");
        connection.setDoInput(true);
        connection.setDoOutput(false);
        connection.setUseCaches(false);
        connection.connect();
        String responseMessage = connection.getResponseMessage();
        int responseCode = connection.getResponseCode();
        LOGGER.debug((Object)("delete step in delegate(), response code: " + responseCode));
        LOGGER.debug((Object)("delete step in delegate(), response message: " + responseMessage));
        switch (responseCode) {
            case 204: {
                return;
            }
            case 404: 
            case 409: {
                throw new ResourceNotFoundException(responseMessage);
            }
            case 400: {
                throw new IllegalArgumentException(responseMessage);
            }
            case 403: {
                throw new AccessControlException(responseMessage);
            }
        }
        throw new RuntimeException("Unexpected failure mode: " + responseMessage + "(" + responseCode + ")");
    }

    public String getEncodedCSR(X500Principal userDN) throws IOException, InvalidKeyException, CertificateEncodingException, CertificateParsingException, CertificateExpiredException, CertificateNotYetValidException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, CertificateException, ResourceNotFoundException {
        String location = this.getLocation(userDN);
        if (location == null) {
            throw new IllegalArgumentException("No certificate found for " + userDN);
        }
        return this.getEncodedCSR(location, userDN);
    }

    private String getEncodedCSR(String location, X500Principal userDN) throws IOException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, CertificateEncodingException, CertificateParsingException, CertificateExpiredException, CertificateNotYetValidException, ResourceNotFoundException {
        URL resourceURL = new URL(location + "/CSR");
        LOGGER.debug((Object)("get CSR step in delegate(), URL=" + resourceURL));
        HttpsURLConnection connection = this.openConnection(resourceURL);
        connection.setRequestMethod("GET");
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        connection.connect();
        String responseMessage = connection.getResponseMessage();
        int responseCode = connection.getResponseCode();
        LOGGER.debug((Object)("get CSR step in delegate(), response code: " + responseCode));
        LOGGER.debug((Object)("get CSR step in delegate(), response message: " + responseMessage));
        switch (responseCode) {
            case 200: {
                try {
                    int bytesRead;
                    byte[] csr = null;
                    InputStream in = connection.getInputStream();
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = in.read(buffer, 0, buffer.length)) != -1) {
                        out.write(buffer, 0, bytesRead);
                    }
                    out.flush();
                    csr = out.toByteArray();
                    in.close();
                    LOGGER.debug((Object)("Downloaded CSR of size: " + csr.length));
                    return new String(csr);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("UTF-8 encoding not supported");
                }
            }
            case 404: 
            case 409: {
                throw new ResourceNotFoundException(responseMessage);
            }
            case 400: {
                throw new IllegalArgumentException(responseMessage);
            }
            case 403: {
                throw new AccessControlException(responseMessage);
            }
        }
        throw new RuntimeException("Unexpected failure mode: " + responseMessage + "(" + responseCode + ")");
    }

    public X509Certificate[] getCertificate(X500Principal userDN) throws IOException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, CertificateEncodingException, CertificateParsingException, CertificateException, ResourceNotFoundException {
        String location = this.getLocation(userDN);
        URL resourceURL = new URL(location + "/certificate");
        LOGGER.debug((Object)("get certificate, URL=" + resourceURL));
        HttpsURLConnection connection = this.openConnection(resourceURL);
        connection.setRequestMethod("GET");
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        connection.connect();
        String responseMessage = connection.getResponseMessage();
        int responseCode = connection.getResponseCode();
        LOGGER.debug((Object)("get certificate, response code: " + responseCode));
        LOGGER.debug((Object)("get certificate, response message: " + responseMessage));
        switch (responseCode) {
            case 200: {
                try {
                    int bytesRead;
                    InputStream in = connection.getInputStream();
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = in.read(buffer, 0, buffer.length)) != -1) {
                        out.write(buffer, 0, bytesRead);
                    }
                    out.flush();
                    byte[] certBuf = out.toByteArray();
                    in.close();
                    X509Certificate[] certs = SSLUtil.readCertificateChain((byte[])SSLUtil.getCertificates((byte[])certBuf));
                    return certs;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("UTF-8 encoding not supported");
                }
            }
            case 404: 
            case 409: {
                throw new ResourceNotFoundException(responseMessage);
            }
            case 400: {
                throw new IllegalArgumentException(responseMessage);
            }
            case 401: {
                throw new AccessControlException(responseMessage);
            }
        }
        throw new RuntimeException("Unexpected failure mode: " + responseMessage + "(" + responseCode + ")");
    }

    public String getLocation(X500Principal userDN) throws IOException, CertificateException, ResourceNotFoundException {
        StringBuilder resourcePath = new StringBuilder(64);
        if (userDN != null) {
            resourcePath.append("?DN=");
            resourcePath.append(URLEncoder.encode(userDN.getName(), "UTF-8"));
        }
        URL credUrl = this.getRegistryClient().getServiceURL(this.serviceID, Standards.CRED_DELEGATE_10, AuthMethod.CERT);
        URL resourceURL = new URL(credUrl.toExternalForm() + "/" + resourcePath.toString());
        LOGGER.debug((Object)("get hash, URL=" + resourceURL));
        HttpsURLConnection connection = this.openConnection(resourceURL);
        connection.setRequestMethod("GET");
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        connection.connect();
        String responseMessage = connection.getResponseMessage();
        int responseCode = connection.getResponseCode();
        LOGGER.debug((Object)("get hash, response code: " + responseCode));
        LOGGER.debug((Object)("get hash, response message: " + responseMessage));
        switch (responseCode) {
            case 200: {
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    String hash = reader.readLine();
                    if (reader.readLine() != null) {
                        throw new CertificateException("Only one hash expected");
                    }
                    String hashPath = "/" + hash;
                    URL u = new URL(credUrl.toExternalForm() + "/" + hashPath);
                    return u.toExternalForm();
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("UTF-8 encoding not supported");
                }
            }
            case 404: 
            case 409: {
                throw new ResourceNotFoundException(responseMessage);
            }
            case 400: {
                throw new IllegalArgumentException(responseMessage);
            }
            case 401: {
                throw new AccessControlException(responseMessage);
            }
        }
        throw new RuntimeException("Unexpected failure mode: " + responseMessage + "(" + responseCode + ")");
    }

    public void putSignedCert(X509Certificate[] chain) throws IOException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, CertificateException, ResourceNotFoundException {
        X500Principal delegatedUser = chain[0].getSubjectX500Principal();
        String location = this.getLocation(delegatedUser);
        this.putSignedCert(location, chain, delegatedUser);
    }

    private X509Certificate[] createProxyCertChain(X509Certificate cert) {
        Set<X509CertificateChain> cc;
        AccessControlContext ac = AccessController.getContext();
        Subject subject = Subject.getSubject(ac);
        if (subject != null && (cc = subject.getPublicCredentials(X509CertificateChain.class)).size() > 0) {
            X509CertificateChain xcc = cc.iterator().next();
            X509Certificate[] chain = xcc.getChain();
            X509Certificate[] ret = new X509Certificate[chain.length + 1];
            ret[0] = cert;
            for (int i = 0; i < chain.length; ++i) {
                ret[i + 1] = chain[i];
            }
            return ret;
        }
        throw new IllegalStateException("current Subject does not contain a certficate chain");
    }

    private void putSignedCert(String location, X509Certificate[] certs, X500Principal userDN) throws IOException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, CertificateEncodingException, CertificateParsingException, ResourceNotFoundException {
        LOGGER.debug((Object)("putSignedCert: " + userDN + " chain length: " + certs.length));
        StringBuilder resourcePath = new StringBuilder(64);
        resourcePath.append(location);
        resourcePath.append("/certificate");
        if (userDN != null) {
            resourcePath.append("?DN=");
            resourcePath.append(URLEncoder.encode(userDN.getName(), "UTF-8"));
        }
        URL resourceURL = new URL(resourcePath.toString());
        LOGGER.debug((Object)("put certificate step in delegate(), URL=" + resourceURL));
        HttpsURLConnection connection = this.openConnection(resourceURL);
        connection.setRequestMethod("PUT");
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        OutputStream os = connection.getOutputStream();
        JcaPEMWriter writer = new JcaPEMWriter((Writer)new OutputStreamWriter(os));
        for (X509Certificate c : certs) {
            writer.writeObject((Object)c);
        }
        writer.flush();
        writer.close();
        String responseMessage = connection.getResponseMessage();
        int responseCode = connection.getResponseCode();
        LOGGER.debug((Object)("put certificate step in delegate(), response code: " + responseCode));
        LOGGER.debug((Object)("put certificate step in delegate(), response message: " + responseMessage));
        switch (responseCode) {
            case 200: {
                LOGGER.debug((Object)"Certificate uploaded");
                break;
            }
            case 404: 
            case 409: {
                throw new ResourceNotFoundException(responseMessage);
            }
            case 400: {
                throw new IllegalArgumentException(responseMessage);
            }
            case 401: {
                throw new AccessControlException(responseMessage);
            }
            default: {
                throw new RuntimeException("Unexpected failure mode: " + responseMessage + "(" + responseCode + ")");
            }
        }
    }

    protected HttpsURLConnection openConnection(URL url) throws IOException {
        if (!url.getProtocol().equals("https")) {
            throw new IllegalArgumentException("Wrong protocol: " + url.getProtocol() + ". CDP works on https only");
        }
        AccessControlContext ac = AccessController.getContext();
        Subject subject = Subject.getSubject(ac);
        SSLSocketFactory sf = SSLUtil.getSocketFactory((Subject)subject);
        HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
        con.setSSLSocketFactory(sf);
        return con;
    }

    public X509Certificate generateV3Certificate(PKCS10CertificationRequest csr, int lifetime) throws InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, CertificateEncodingException, CertificateParsingException, CertificateExpiredException, CertificateNotYetValidException {
        Set<X509CertificateChain> certs;
        AccessControlContext ac = AccessController.getContext();
        Subject subject = Subject.getSubject(ac);
        X509CertificateChain chain = null;
        if (subject != null && (certs = subject.getPublicCredentials(X509CertificateChain.class)).size() > 0) {
            chain = certs.iterator().next();
        }
        if (chain == null) {
            throw new AccessControlException("Subject not authorized");
        }
        return CertUtil.generateCertificate(csr, lifetime, chain);
    }

    public static PKCS10CertificationRequest readCSR(byte[] code) throws IOException {
        byte[] crt = CredClient.getCSR(code);
        return new PKCS10CertificationRequest(crt);
    }

    protected RegistryClient getRegistryClient() {
        if (this.reg == null) {
            this.reg = new RegistryClient();
        }
        return this.reg;
    }

    static byte[] getCSR(byte[] certBuf) throws IOException {
        BufferedReader rdr = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(certBuf)));
        String line = rdr.readLine();
        StringBuilder base64 = new StringBuilder();
        while (line != null) {
            if (line.startsWith("-----BEGIN CERTIFICATE REQUEST-")) {
                LOGGER.debug((Object)line);
                line = rdr.readLine();
                while (line != null && !line.startsWith("-----END CERTIFICATE REQUEST-")) {
                    LOGGER.debug((Object)(line + " (" + line.length() + ")"));
                    base64.append(line.trim());
                    line = rdr.readLine();
                }
                LOGGER.debug((Object)line);
                line = null;
                continue;
            }
            line = rdr.readLine();
        }
        rdr.close();
        String encoded = base64.toString();
        LOGGER.debug((Object)("CERTIFICATE REQUEST: " + encoded));
        byte[] ret = Base64.decode((String)encoded);
        LOGGER.debug((Object)("RSA private key: " + ret.length + " bytes"));
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X509CertificateChain downloadCertificate(URL location) throws AccessControlException, IOException, ResourceNotFoundException {
        ByteArrayOutputStream bos;
        Profiler profiler = new Profiler(this.getClass());
        byte[] certificate = null;
        try {
            bos = new ByteArrayOutputStream();
            HttpGet get = new HttpGet(location, (OutputStream)bos);
            get.run();
            if (get.getThrowable() != null) {
                if (get.getThrowable() instanceof IOException) {
                    throw (IOException)get.getThrowable();
                }
                if (get.getThrowable() instanceof AccessControlException) {
                    throw (AccessControlException)get.getThrowable();
                }
                if (get.getThrowable() instanceof FileNotFoundException) {
                    throw new ResourceNotFoundException(get.getThrowable().getMessage(), get.getThrowable());
                }
                throw new RuntimeException("unexpected failure download certificate", get.getThrowable());
            }
            certificate = bos.toByteArray();
            LOGGER.debug((Object)("Downloaded Certificate of size: " + certificate.length));
        }
        finally {
            profiler.checkpoint("downloadCertificate");
        }
        if (certificate != null && certificate.length > 0) {
            try {
                bos = SSLUtil.readPemCertificateAndKey((byte[])certificate);
                return bos;
            }
            catch (GeneralSecurityException e) {
                LOGGER.warn((Object)e);
                throw new IllegalStateException("Could not parse the certificate", e);
            }
            finally {
                profiler.checkpoint("parseCertificate");
            }
        }
        throw new RuntimeException("No content in certificate");
    }
}

