/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.cred;

import ca.nrc.cadc.auth.X509CertificateChain;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Random;
import java.util.TimeZone;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509ExtensionUtils;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;

public class CertUtil {
    private static final Logger log = Logger.getLogger(CertUtil.class);
    public static final String DEFAULT_SIGNATURE_ALGORITHM = "SHA256WITHRSA";
    public static final int DEFAULT_KEY_LENGTH = 2048;

    public static X509Certificate generateCertificate(PKCS10CertificationRequest csr, int lifetime, X509CertificateChain chain) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, CertificateParsingException, CertificateEncodingException, SignatureException, CertificateExpiredException, CertificateNotYetValidException {
        X509Certificate issuerCert = chain.getChain()[0];
        PrivateKey issuerKey = chain.getPrivateKey();
        Security.addProvider((Provider)new BouncyCastleProvider());
        BigInteger serial = BigInteger.valueOf(System.currentTimeMillis());
        X500Name issuer = CertUtil.flipDN(issuerCert.getSubjectX500Principal().getName("RFC2253"));
        log.debug((Object)("issuer: " + issuer));
        Random rand = new Random();
        String delegCN = String.valueOf(Math.abs(rand.nextInt()));
        X500Name subject = new X500Name(issuer.toString() + ",CN=" + delegCN);
        log.debug((Object)("subject: " + subject));
        GregorianCalendar date = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        date.add(12, -65);
        Date beforeDate = date.getTime();
        for (X509Certificate currentCert : chain.getChain()) {
            if (!beforeDate.before(currentCert.getNotBefore())) continue;
            beforeDate = currentCert.getNotBefore();
        }
        date = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        Date afterDate = date.getTime();
        if (lifetime <= 0) {
            afterDate = issuerCert.getNotAfter();
            for (X509Certificate currentCert : chain.getChain()) {
                if (!afterDate.after(currentCert.getNotAfter())) continue;
                afterDate = currentCert.getNotAfter();
            }
        } else {
            date.add(12, 5);
            date.add(13, lifetime);
            for (X509Certificate currentCert : chain.getChain()) {
                currentCert.checkValidity(date.getTime());
            }
            afterDate = date.getTime();
        }
        log.debug((Object)("CSR: " + csr.getSubject()));
        X509v3CertificateBuilder certGen = new X509v3CertificateBuilder(issuer, serial, beforeDate, afterDate, subject, csr.getSubjectPublicKeyInfo());
        try {
            ASN1EncodableVector policy = new ASN1EncodableVector();
            policy.add((ASN1Encodable)new ASN1ObjectIdentifier("1.3.6.1.5.5.7.21.1"));
            ASN1EncodableVector vec = new ASN1EncodableVector();
            vec.add((ASN1Encodable)new DERSequence(policy));
            ASN1ObjectIdentifier extProxyCert = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.1.14");
            certGen.addExtension(extProxyCert, true, (ASN1Encodable)new DERSequence(vec));
            BcDigestCalculatorProvider dcp = new BcDigestCalculatorProvider();
            DigestCalculator dc = dcp.get(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1));
            X509ExtensionUtils x509ext = new X509ExtensionUtils(dc);
            certGen.addExtension(Extension.keyUsage, false, new KeyUsage(176).getEncoded());
            certGen.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)x509ext.createSubjectKeyIdentifier(csr.getSubjectPublicKeyInfo()));
            JcaX509CertificateHolder issuerCH = new JcaX509CertificateHolder(issuerCert);
            certGen.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)x509ext.createAuthorityKeyIdentifier((X509CertificateHolder)issuerCH));
        }
        catch (IOException | OperatorCreationException ex) {
            throw new RuntimeException("failed to add X509 extensions", ex);
        }
        try {
            ContentSigner signer = new JcaContentSignerBuilder(DEFAULT_SIGNATURE_ALGORITHM).setProvider("BC").build(issuerKey);
            JcaX509CertificateConverter converter = new JcaX509CertificateConverter().setProvider("BC");
            return converter.getCertificate(certGen.build(signer));
        }
        catch (CertificateException | OperatorCreationException ex) {
            throw new RuntimeException("failed to create+sign proxy cert", ex);
        }
    }

    private static X500Name flipDN(String sdn) {
        try {
            LdapName dn = new LdapName(sdn);
            List<Rdn> rdns = dn.getRdns();
            StringBuilder sb = new StringBuilder();
            for (Rdn r : rdns) {
                sb.append(r.toString());
                sb.append(",");
            }
            return new X500Name(sb.substring(0, sb.length() - 1));
        }
        catch (InvalidNameException ex) {
            throw new RuntimeException("BUG: failed to flip DN", ex);
        }
    }

    public static void writePEMCertificateAndKey(X509CertificateChain chain, Writer writer) throws IOException {
        if (chain == null) {
            throw new IllegalArgumentException("Null certificate chain");
        }
        if (writer == null) {
            throw new IllegalArgumentException("Null writer");
        }
        JcaPEMWriter pemWriter = new JcaPEMWriter(writer);
        pemWriter.writeObject((Object)chain.getChain()[0]);
        pemWriter.writeObject((Object)chain.getPrivateKey());
        for (int i = 1; i < chain.getChain().length; ++i) {
            pemWriter.writeObject((Object)chain.getChain()[i]);
        }
        pemWriter.flush();
    }
}

