/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.ac.xml;

import ca.nrc.cadc.ac.Group;
import ca.nrc.cadc.ac.WriterException;
import ca.nrc.cadc.ac.xml.AbstractReaderWriter;
import ca.nrc.cadc.util.StringBuilderWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collection;
import org.jdom2.Content;
import org.jdom2.Element;

public class GroupListWriter
extends AbstractReaderWriter {
    public void write(Collection<Group> groups, StringBuilder builder) throws IOException, WriterException {
        this.write(groups, (Writer)new StringBuilderWriter(builder));
    }

    public void write(Collection<Group> groups, OutputStream out) throws IOException, WriterException {
        OutputStreamWriter outWriter;
        try {
            outWriter = new OutputStreamWriter(out, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding not supported", e);
        }
        this.write(groups, (Writer)new BufferedWriter(outWriter));
    }

    public void write(Collection<Group> groups, Writer writer) throws IOException, WriterException {
        if (groups == null) {
            throw new WriterException("null groups");
        }
        this.write(this.getElement(groups), writer);
    }

    protected final Element getElement(Collection<Group> groups) throws WriterException {
        Element groupsElement = new Element("groups");
        for (Group group : groups) {
            groupsElement.addContent((Content)this.getElement(group));
        }
        return groupsElement;
    }
}

