/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.ac.xml;

import ca.nrc.cadc.ac.Group;
import ca.nrc.cadc.ac.GroupProperty;
import ca.nrc.cadc.ac.InternalID;
import ca.nrc.cadc.ac.PersonalDetails;
import ca.nrc.cadc.ac.PosixDetails;
import ca.nrc.cadc.ac.ReaderException;
import ca.nrc.cadc.ac.User;
import ca.nrc.cadc.ac.UserRequest;
import ca.nrc.cadc.ac.WriterException;
import ca.nrc.cadc.auth.DNPrincipal;
import ca.nrc.cadc.auth.HttpPrincipal;
import ca.nrc.cadc.auth.IdentityType;
import ca.nrc.cadc.auth.NumericPrincipal;
import ca.nrc.cadc.auth.PosixPrincipal;
import ca.nrc.cadc.date.DateUtil;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import javax.security.auth.x500.X500Principal;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.opencadc.gms.GroupURI;

public abstract class AbstractReaderWriter {
    public static final String ADDRESS = "address";
    public static final String AUTHORITY = "authority";
    public static final String CITY = "city";
    public static final String COUNTRY = "country";
    public static final String EMAIL = "email";
    public static final String DESCRIPTION = "description";
    public static final String FIRST_NAME = "firstName";
    public static final String GID = "gid";
    public static final String GROUP = "group";
    public static final String GROUPS = "groups";
    public static final String GROUP_ADMINS = "groupAdmins";
    public static final String GROUP_MEMBERS = "groupMembers";
    public static final String HOME_DIRECTORY = "homeDirectory";
    public static final String ID = "id";
    public static final String IDENTITY = "identity";
    public static final String IDENTITIES = "identities";
    public static final String INSTITUTE = "institute";
    public static final String INTEGER = "Integer";
    public static final String INTERNAL_ID = "internalID";
    public static final String KEY = "key";
    public static final String LAST_MODIFIED = "lastModified";
    public static final String LAST_NAME = "lastName";
    public static final String OWNER = "owner";
    public static final String PASSWORD = "password";
    public static final String PERSONAL_DETAILS = "personalDetails";
    public static final String POSIX_DETAILS = "posixDetails";
    public static final String PROPERTIES = "properties";
    public static final String PROPERTY = "property";
    public static final String READ_ONLY = "readOnly";
    public static final String STRING = "String";
    public static final String TYPE = "type";
    public static final String UID = "uid";
    public static final String URI = "uri";
    public static final String USER = "user";
    public static final String USERNAME = "username";
    public static final String USERS = "users";
    public static final String USER_ADMINS = "userAdmins";
    public static final String USER_MEMBERS = "userMembers";
    public static final String USER_REQUEST = "userRequest";

    protected void write(Element root, Writer writer) throws IOException {
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(Format.getPrettyFormat());
        outputter.output(new Document(root), writer);
    }

    protected final User getUser(Element element) throws ReaderException {
        Element posixDetailsElement;
        Element personalDetailsElement;
        Element identitiesElement;
        User user = new User();
        Element internalIDElement = element.getChild(INTERNAL_ID);
        if (internalIDElement != null) {
            this.setInternalID(user, internalIDElement);
        }
        if ((identitiesElement = element.getChild(IDENTITIES)) != null) {
            List identityElements = identitiesElement.getChildren(IDENTITY);
            for (Element identityElement : identityElements) {
                user.getIdentities().add(this.getPrincipal(identityElement));
            }
        }
        if ((personalDetailsElement = element.getChild(PERSONAL_DETAILS)) != null) {
            user.personalDetails = this.getPersonalDetails(personalDetailsElement);
        }
        if ((posixDetailsElement = element.getChild(POSIX_DETAILS)) != null) {
            user.posixDetails = this.getPosixDetails(posixDetailsElement);
        }
        return user;
    }

    protected final UserRequest getUserRequest(Element element) throws ReaderException {
        Element userElement = element.getChild(USER);
        if (userElement == null) {
            String error = "user element not found in userRequest element";
            throw new ReaderException(error);
        }
        User user = this.getUser(userElement);
        Element passwordElement = element.getChild(PASSWORD);
        if (passwordElement == null) {
            String error = "password element not found in userRequest element";
            throw new ReaderException(error);
        }
        String password = passwordElement.getText();
        return new UserRequest(user, password.toCharArray());
    }

    protected final Principal getPrincipal(Element element) throws ReaderException {
        Object principal;
        if (element == null) {
            String error = "null identity element";
            throw new ReaderException(error);
        }
        if (!element.getName().equals(IDENTITY)) {
            String error = "expected identity element name, found " + element.getName();
            throw new ReaderException(error);
        }
        String type = element.getAttributeValue(TYPE);
        if (type == null) {
            String error = "type attribute not found in identity element" + element.getName();
            throw new ReaderException(error);
        }
        String identity = element.getText();
        if (type.equals(IdentityType.CADC.getValue())) {
            principal = new NumericPrincipal(UUID.fromString(identity));
        } else if (type.equals(IdentityType.USERNAME.getValue())) {
            principal = new HttpPrincipal(identity);
        } else if (type.equals(IdentityType.X500.getValue())) {
            principal = new X500Principal(identity);
        } else if (type.equals(IdentityType.ENTRY_DN.getValue())) {
            principal = new DNPrincipal(identity);
        } else if (type.equals(IdentityType.POSIX.getValue())) {
            principal = new PosixPrincipal(Integer.parseInt(identity));
        } else {
            String error = "Unknown type attribute: " + type;
            throw new ReaderException(error);
        }
        return principal;
    }

    protected final PosixDetails getPosixDetails(Element element) throws ReaderException {
        int gid;
        int uid;
        if (element == null) {
            String error = "null posixDetails element";
            throw new ReaderException(error);
        }
        Element userNameElement = element.getChild(USERNAME);
        if (userNameElement == null) {
            String error = "posixDetails missing required element username";
            throw new ReaderException(error);
        }
        String username = userNameElement.getText();
        Element uidElement = element.getChild(UID);
        if (uidElement == null) {
            String error = "posixDetails missing required element uid";
            throw new ReaderException(error);
        }
        try {
            uid = Integer.parseInt(uidElement.getText());
        }
        catch (NumberFormatException e) {
            String error = "Cannot parse posixDetails uid to a long";
            throw new ReaderException(error);
        }
        Element gidElement = element.getChild(GID);
        if (gidElement == null) {
            String error = "posixDetails missing required element gid";
            throw new ReaderException(error);
        }
        try {
            gid = Integer.parseInt(gidElement.getText());
        }
        catch (NumberFormatException e) {
            String error = "Cannot parse posixDetails gid to a long";
            throw new ReaderException(error);
        }
        Element homeDirElement = element.getChild(HOME_DIRECTORY);
        if (homeDirElement == null) {
            String error = "posixDetails missing required element homeDirectory";
            throw new ReaderException(error);
        }
        String homeDirectory = homeDirElement.getText();
        return new PosixDetails(username, uid, gid, homeDirectory);
    }

    protected final PersonalDetails getPersonalDetails(Element element) throws ReaderException {
        Element countryElement;
        Element cityElement;
        Element instituteElement;
        Element addressElement;
        if (element == null) {
            String error = "null personalDetails element";
            throw new ReaderException(error);
        }
        Element firstNameElement = element.getChild(FIRST_NAME);
        if (firstNameElement == null) {
            String error = "personalDetails missing required element firstName";
            throw new ReaderException(error);
        }
        String firstName = firstNameElement.getText();
        Element lastNameElement = element.getChild(LAST_NAME);
        if (lastNameElement == null) {
            String error = "personalDetails missing required element lastName";
            throw new ReaderException(error);
        }
        String lastName = lastNameElement.getText();
        PersonalDetails details = new PersonalDetails(firstName, lastName);
        Element emailElement = element.getChild(EMAIL);
        if (emailElement != null) {
            details.email = emailElement.getText();
        }
        if ((addressElement = element.getChild(ADDRESS)) != null) {
            details.address = addressElement.getText();
        }
        if ((instituteElement = element.getChild(INSTITUTE)) != null) {
            details.institute = instituteElement.getText();
        }
        if ((cityElement = element.getChild(CITY)) != null) {
            details.city = cityElement.getText();
        }
        if ((countryElement = element.getChild(COUNTRY)) != null) {
            details.country = countryElement.getText();
        }
        return details;
    }

    protected final Group getGroup(Element element) throws ReaderException {
        Element userAdminsElement;
        Element groupAdminsElement;
        Element userMembersElement;
        Element groupMembersElement;
        Element propertiesElement;
        Element lastModifiedElement;
        Element descriptionElement;
        Group group;
        String uri = element.getAttributeValue(URI);
        if (uri == null) {
            String error = "group missing required uri attribute";
            throw new ReaderException(error);
        }
        User user = null;
        Element ownerElement = element.getChild(OWNER);
        if (ownerElement != null) {
            Element userElement = ownerElement.getChild(USER);
            if (userElement == null) {
                String error = "owner missing required user element";
                throw new ReaderException(error);
            }
            user = this.getUser(userElement);
        }
        try {
            GroupURI groupURI = new GroupURI(uri);
            group = new Group(groupURI);
        }
        catch (URISyntaxException ex) {
            throw new ReaderException("invalid group URI: " + uri);
        }
        this.setField(group, user, OWNER);
        Element gidElement = element.getChild(GID);
        if (gidElement != null) {
            group.gid = Integer.parseInt(gidElement.getText());
        }
        if ((descriptionElement = element.getChild(DESCRIPTION)) != null) {
            group.description = descriptionElement.getText();
        }
        if ((lastModifiedElement = element.getChild(LAST_MODIFIED)) != null) {
            try {
                DateFormat df = DateUtil.getDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss.SSS", (TimeZone)DateUtil.UTC);
                group.lastModified = df.parse(lastModifiedElement.getText());
            }
            catch (ParseException e) {
                String error = "Unable to parse group lastModified because " + e.getMessage();
                throw new ReaderException(error);
            }
        }
        if ((propertiesElement = element.getChild(PROPERTIES)) != null) {
            List propertyElements = propertiesElement.getChildren(PROPERTY);
            for (Element propertyElement : propertyElements) {
                group.getProperties().add(this.getGroupProperty(propertyElement));
            }
        }
        if ((groupMembersElement = element.getChild(GROUP_MEMBERS)) != null) {
            List groupElements = groupMembersElement.getChildren(GROUP);
            for (Element groupMember : groupElements) {
                group.getGroupMembers().add(this.getGroup(groupMember));
            }
        }
        if ((userMembersElement = element.getChild(USER_MEMBERS)) != null) {
            List userElements = userMembersElement.getChildren(USER);
            for (Element userMember : userElements) {
                group.getUserMembers().add(this.getUser(userMember));
            }
        }
        if ((groupAdminsElement = element.getChild(GROUP_ADMINS)) != null) {
            List groupElements = groupAdminsElement.getChildren(GROUP);
            for (Element groupMember : groupElements) {
                group.getGroupAdmins().add(this.getGroup(groupMember));
            }
        }
        if ((userAdminsElement = element.getChild(USER_ADMINS)) != null) {
            List userElements = userAdminsElement.getChildren(USER);
            for (Element userMember : userElements) {
                group.getUserAdmins().add(this.getUser(userMember));
            }
        }
        return group;
    }

    protected final GroupProperty getGroupProperty(Element element) throws ReaderException {
        Object value;
        if (element == null) {
            String error = "null property element";
            throw new ReaderException(error);
        }
        if (!element.getName().equals(PROPERTY)) {
            String error = "expected property element name, found " + element.getName();
            throw new ReaderException(error);
        }
        String key = element.getAttributeValue(KEY);
        if (key == null) {
            String error = "required key attribute not found";
            throw new ReaderException(error);
        }
        String type = element.getAttributeValue(TYPE);
        if (type == null) {
            String error = "required type attribute not found";
            throw new ReaderException(error);
        }
        if (type.equals(STRING)) {
            value = String.valueOf(element.getText());
        } else if (type.equals(INTEGER)) {
            value = Integer.valueOf(element.getText());
        } else {
            String error = "Unsupported GroupProperty type: " + type;
            throw new ReaderException(error);
        }
        Boolean readOnly = Boolean.valueOf(element.getAttributeValue(READ_ONLY));
        return new GroupProperty(key, value, readOnly);
    }

    protected final Element getElement(User user) throws WriterException {
        Set<Principal> identities;
        if (user == null) {
            throw new WriterException("null User");
        }
        Element userElement = new Element(USER);
        if (user.getID() != null) {
            userElement.addContent((Content)this.getElement(user.getID()));
        }
        if (!(identities = user.getIdentities()).isEmpty()) {
            Element identitiesElement = new Element(IDENTITIES);
            for (Principal identity : identities) {
                identitiesElement.addContent((Content)this.getElement(identity));
            }
            userElement.addContent((Content)identitiesElement);
        }
        if (user.personalDetails != null) {
            userElement.addContent((Content)this.getElement(user.personalDetails));
        }
        if (user.posixDetails != null) {
            userElement.addContent((Content)this.getElement(user.posixDetails));
        }
        return userElement;
    }

    protected final Element getElement(UserRequest userRequest) throws WriterException {
        if (userRequest == null) {
            throw new WriterException("null UserRequest");
        }
        Element userRequestElement = new Element(USER_REQUEST);
        Element userElement = this.getElement(userRequest.getUser());
        userRequestElement.addContent((Content)userElement);
        Element passwordElement = new Element(PASSWORD);
        passwordElement.setText(String.valueOf(userRequest.getPassword()));
        userRequestElement.addContent((Content)passwordElement);
        return userRequestElement;
    }

    protected final Element getElement(InternalID internalID) throws WriterException {
        if (internalID == null) {
            throw new WriterException("null InternalID");
        }
        Element internalIDElement = new Element(INTERNAL_ID);
        Element uriElement = new Element(URI);
        uriElement.addContent(internalID.getURI().toString());
        internalIDElement.addContent((Content)uriElement);
        return internalIDElement;
    }

    protected final Element getElement(Principal identity) throws WriterException {
        if (identity == null) {
            String error = "null Principal";
            throw new WriterException(error);
        }
        Element identityElement = new Element(IDENTITY);
        if (identity instanceof HttpPrincipal) {
            identityElement.setAttribute(TYPE, IdentityType.USERNAME.getValue());
        } else if (identity instanceof NumericPrincipal) {
            identityElement.setAttribute(TYPE, IdentityType.CADC.getValue());
        } else if (identity instanceof X500Principal) {
            identityElement.setAttribute(TYPE, IdentityType.X500.getValue());
        } else if (identity instanceof DNPrincipal) {
            identityElement.setAttribute(TYPE, IdentityType.ENTRY_DN.getValue());
        } else if (identity instanceof PosixPrincipal) {
            identityElement.setAttribute(TYPE, IdentityType.POSIX.getValue());
        } else {
            String error = "Unsupported Principal type " + identity.getClass().getSimpleName();
            throw new IllegalArgumentException(error);
        }
        identityElement.setText(identity.getName());
        return identityElement;
    }

    protected final Element getElement(PosixDetails details) throws WriterException {
        if (details == null) {
            String error = "null PosixDetails";
            throw new WriterException(error);
        }
        Element detailsElement = new Element(POSIX_DETAILS);
        Element usernameElement = new Element(USERNAME);
        usernameElement.setText(details.getUsername());
        detailsElement.addContent((Content)usernameElement);
        Element uidElement = new Element(UID);
        uidElement.setText(String.valueOf(details.getUid()));
        detailsElement.addContent((Content)uidElement);
        Element gidElement = new Element(GID);
        gidElement.setText(String.valueOf(details.getGid()));
        detailsElement.addContent((Content)gidElement);
        Element homeDirElement = new Element(HOME_DIRECTORY);
        homeDirElement.setText(details.getHomeDirectory());
        detailsElement.addContent((Content)homeDirElement);
        return detailsElement;
    }

    protected final Element getElement(PersonalDetails details) throws WriterException {
        if (details == null) {
            String error = "null PersonalDetails";
            throw new WriterException(error);
        }
        Element detailsElement = new Element(PERSONAL_DETAILS);
        Element firstNameElement = new Element(FIRST_NAME);
        firstNameElement.setText(details.getFirstName());
        detailsElement.addContent((Content)firstNameElement);
        Element lastNameElement = new Element(LAST_NAME);
        lastNameElement.setText(details.getLastName());
        detailsElement.addContent((Content)lastNameElement);
        if (details.email != null) {
            Element emailElement = new Element(EMAIL);
            emailElement.setText(details.email);
            detailsElement.addContent((Content)emailElement);
        }
        if (details.address != null) {
            Element addressElement = new Element(ADDRESS);
            addressElement.setText(details.address);
            detailsElement.addContent((Content)addressElement);
        }
        if (details.institute != null) {
            Element instituteElement = new Element(INSTITUTE);
            instituteElement.setText(details.institute);
            detailsElement.addContent((Content)instituteElement);
        }
        if (details.city != null) {
            Element cityElement = new Element(CITY);
            cityElement.setText(details.city);
            detailsElement.addContent((Content)cityElement);
        }
        if (details.country != null) {
            Element countryElement = new Element(COUNTRY);
            countryElement.setText(details.country);
            detailsElement.addContent((Content)countryElement);
        }
        return detailsElement;
    }

    protected final Element getElement(Group group) throws WriterException {
        return this.getElement(group, true);
    }

    protected final Element getElement(Group group, boolean deepCopy) throws WriterException {
        if (group == null) {
            throw new WriterException("null Group");
        }
        Element groupElement = new Element(GROUP);
        String groupURI = group.getID().toString();
        groupElement.setAttribute(new Attribute(URI, groupURI));
        if (group.gid != null) {
            Element gidElement = new Element(GID);
            gidElement.setText(group.gid.toString());
            groupElement.addContent((Content)gidElement);
        }
        if (group.getOwner() != null) {
            Element ownerElement = new Element(OWNER);
            Element userElement = this.getElement(group.getOwner());
            ownerElement.addContent((Content)userElement);
            groupElement.addContent((Content)ownerElement);
        }
        if (deepCopy) {
            if (group.description != null) {
                Element descriptionElement = new Element(DESCRIPTION);
                descriptionElement.setText(group.description);
                groupElement.addContent((Content)descriptionElement);
            }
            if (group.lastModified != null) {
                Element lastModifiedElement = new Element(LAST_MODIFIED);
                DateFormat df = DateUtil.getDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss.SSS", (TimeZone)DateUtil.UTC);
                lastModifiedElement.setText(df.format(group.lastModified));
                groupElement.addContent((Content)lastModifiedElement);
            }
            if (!group.getProperties().isEmpty()) {
                Element propertiesElement = new Element(PROPERTIES);
                for (GroupProperty property : group.getProperties()) {
                    propertiesElement.addContent((Content)this.getElement(property));
                }
                groupElement.addContent((Content)propertiesElement);
            }
            if (group.getGroupMembers() != null && !group.getGroupMembers().isEmpty()) {
                Element groupMembersElement = new Element(GROUP_MEMBERS);
                for (Group groupMember : group.getGroupMembers()) {
                    groupMembersElement.addContent((Content)this.getElement(groupMember, false));
                }
                groupElement.addContent((Content)groupMembersElement);
            }
            if (group.getUserMembers() != null && !group.getUserMembers().isEmpty()) {
                Element userMembersElement = new Element(USER_MEMBERS);
                for (User userMember : group.getUserMembers()) {
                    userMembersElement.addContent((Content)this.getElement(userMember));
                }
                groupElement.addContent((Content)userMembersElement);
            }
            if (group.getGroupAdmins() != null && !group.getGroupAdmins().isEmpty()) {
                Element groupAdminsElement = new Element(GROUP_ADMINS);
                for (Group groupMember : group.getGroupAdmins()) {
                    groupAdminsElement.addContent((Content)this.getElement(groupMember, false));
                }
                groupElement.addContent((Content)groupAdminsElement);
            }
            if (group.getUserAdmins() != null && !group.getUserAdmins().isEmpty()) {
                Element userAdminsElement = new Element(USER_ADMINS);
                for (User userMember : group.getUserAdmins()) {
                    userAdminsElement.addContent((Content)this.getElement(userMember));
                }
                groupElement.addContent((Content)userAdminsElement);
            }
        }
        return groupElement;
    }

    protected final Element getElement(GroupProperty property) throws WriterException {
        Object value;
        if (property == null) {
            throw new WriterException("null GroupProperty");
        }
        Element propertyElement = new Element(PROPERTY);
        propertyElement.setAttribute(KEY, property.getKey());
        if (property.isReadOnly()) {
            propertyElement.setAttribute(READ_ONLY, Boolean.TRUE.toString());
        }
        if ((value = property.getValue()) instanceof String) {
            propertyElement.setAttribute(TYPE, STRING);
        } else if (value instanceof Integer) {
            propertyElement.setAttribute(TYPE, INTEGER);
        } else {
            String error = "Unsupported value type: " + value.getClass().getSimpleName();
            throw new IllegalArgumentException(error);
        }
        propertyElement.setText(String.valueOf(property.getValue()));
        return propertyElement;
    }

    private void setInternalID(User user, Element element) throws ReaderException {
        URI uri;
        Element uriElement = element.getChild(URI);
        if (uriElement == null) {
            String error = "expected uri element not found in internalID element";
            throw new ReaderException(error);
        }
        String text = uriElement.getText();
        try {
            uri = new URI(text);
        }
        catch (URISyntaxException e) {
            throw new ReaderException("Invalid InternalID URI " + text, e);
        }
        InternalID internalID = new InternalID(uri);
        this.setField(user, internalID, ID);
    }

    private void setField(Object object, Object value, String name) {
        try {
            Field field = object.getClass().getDeclaredField(name);
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (NoSuchFieldException e) {
            String error = object.getClass().getSimpleName() + " field " + name + "not found";
            throw new RuntimeException(error, e);
        }
        catch (IllegalAccessException e) {
            String error = "unable to update " + name + " in " + object.getClass().getSimpleName();
            throw new RuntimeException(error, e);
        }
    }
}

