/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.ac.client;

import ca.nrc.cadc.ac.Role;
import ca.nrc.cadc.ac.client.GMSClient;
import ca.nrc.cadc.auth.Authorizer;
import ca.nrc.cadc.cred.client.CredUtil;
import ca.nrc.cadc.net.TransientException;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessControlException;
import org.apache.log4j.Logger;
import org.opencadc.gms.GroupURI;

public class GroupAuthorizer
implements Authorizer {
    private static final Logger log = Logger.getLogger(GroupAuthorizer.class);
    private GroupURI groupURI;

    private GroupAuthorizer() {
    }

    public GroupAuthorizer(String uri) {
        try {
            this.groupURI = new GroupURI(uri);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("invalid group URI: " + uri);
        }
    }

    public Object getReadPermission(URI uri) throws AccessControlException, FileNotFoundException, TransientException {
        this.checkMembership();
        return null;
    }

    public Object getWritePermission(URI uri) throws AccessControlException, FileNotFoundException, TransientException {
        this.checkMembership();
        return null;
    }

    private void checkMembership() {
        try {
            if (CredUtil.checkCredentials()) {
                GMSClient gms = new GMSClient(this.groupURI.getServiceID());
                if (gms.isMember(this.groupURI.getName(), Role.MEMBER)) {
                    return;
                }
                throw new AccessControlException("permission denied");
            }
            throw new AccessControlException("permission denied (no credentials)");
        }
        catch (AccessControlException e) {
            throw e;
        }
        catch (Throwable e) {
            String errorMessage = "Failed to check " + this.groupURI + " group membership: " + e.getMessage();
            log.error((Object)errorMessage, e);
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                log.error((Object)("                    reason: " + cause.getCause()));
            }
            throw new IllegalStateException(errorMessage);
        }
    }
}

