/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.ac.client;

import ca.nrc.cadc.ac.Group;
import ca.nrc.cadc.ac.GroupAlreadyExistsException;
import ca.nrc.cadc.ac.GroupNotFoundException;
import ca.nrc.cadc.ac.ReaderException;
import ca.nrc.cadc.ac.Role;
import ca.nrc.cadc.ac.UserNotFoundException;
import ca.nrc.cadc.ac.WriterException;
import ca.nrc.cadc.ac.client.GroupMemberships;
import ca.nrc.cadc.ac.xml.GroupListReader;
import ca.nrc.cadc.ac.xml.GroupReader;
import ca.nrc.cadc.ac.xml.GroupWriter;
import ca.nrc.cadc.auth.AuthMethod;
import ca.nrc.cadc.auth.AuthenticationUtil;
import ca.nrc.cadc.auth.HttpPrincipal;
import ca.nrc.cadc.net.FileContent;
import ca.nrc.cadc.net.HttpDelete;
import ca.nrc.cadc.net.HttpDownload;
import ca.nrc.cadc.net.HttpPost;
import ca.nrc.cadc.net.HttpTransfer;
import ca.nrc.cadc.net.HttpUpload;
import ca.nrc.cadc.net.InputStreamWrapper;
import ca.nrc.cadc.net.NetUtil;
import ca.nrc.cadc.net.ResourceNotFoundException;
import ca.nrc.cadc.net.event.TransferEvent;
import ca.nrc.cadc.net.event.TransferListener;
import ca.nrc.cadc.reg.Standards;
import ca.nrc.cadc.reg.client.RegistryClient;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.opencadc.gms.GroupClient;
import org.opencadc.gms.GroupURI;

public class GMSClient
implements TransferListener,
GroupClient {
    private static final Logger log = Logger.getLogger(GMSClient.class);
    private URI serviceID;

    public GMSClient(URI serviceID) {
        if (serviceID == null) {
            throw new IllegalArgumentException("invalid serviceID: " + serviceID);
        }
        if (serviceID.getFragment() != null) {
            throw new IllegalArgumentException("invalid serviceID (fragment not allowed): " + serviceID);
        }
        this.serviceID = serviceID;
    }

    public void transferEvent(TransferEvent te) {
        if (9 == te.getState()) {
            log.debug((Object)("retry after request failed, reason: " + te.getError()));
        }
    }

    public String getEventHeader() {
        return null;
    }

    public boolean isMember(GroupURI group) {
        if (group == null) {
            throw new IllegalArgumentException("Null group");
        }
        if (!group.getServiceID().equals(this.serviceID)) {
            throw new UnsupportedOperationException("Group is not in the target GMS service.");
        }
        try {
            return this.isMember(group.getName(), Role.MEMBER);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public List<GroupURI> getMemberships() {
        try {
            List<Group> groups = this.getMemberships(Role.MEMBER);
            ArrayList<GroupURI> ret = new ArrayList<GroupURI>(groups.size());
            for (Group next : groups) {
                ret.add(next.getID());
            }
            return ret;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public List<Group> getGroups() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public Group createGroup(Group group) throws GroupAlreadyExistsException, AccessControlException, UserNotFoundException, WriterException, IOException {
        URL createGroupURL = this.lookupServiceURL(Standards.GMS_GROUPS_01);
        log.debug((Object)("createGroupURL request to " + createGroupURL.toString()));
        this.clearCache();
        StringBuilder groupXML = new StringBuilder();
        GroupWriter groupWriter = new GroupWriter();
        groupWriter.write(group, groupXML);
        log.debug((Object)("createGroup: " + groupXML));
        byte[] bytes = groupXML.toString().getBytes("UTF-8");
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        HttpUpload transfer = new HttpUpload((InputStream)in, createGroupURL);
        transfer.run();
        Throwable error = transfer.getThrowable();
        if (error != null) {
            log.debug((Object)"createGroup throwable", error);
            if (transfer.getResponseCode() == -1 || transfer.getResponseCode() == 401 || transfer.getResponseCode() == 403) {
                throw new AccessControlException(error.getMessage());
            }
            if (transfer.getResponseCode() == 400) {
                throw new IllegalArgumentException(error.getMessage());
            }
            if (transfer.getResponseCode() == 409) {
                throw new GroupAlreadyExistsException(error.getMessage());
            }
            if (transfer.getResponseCode() == 404) {
                throw new UserNotFoundException(error.getMessage());
            }
            throw new IOException(error);
        }
        String retXML = transfer.getResponseBody();
        try {
            log.debug((Object)("createGroup returned: " + retXML));
            GroupReader groupReader = new GroupReader();
            return groupReader.read(retXML);
        }
        catch (Exception bug) {
            log.error((Object)"Unexpected exception", (Throwable)bug);
            throw new RuntimeException(bug);
        }
    }

    public Group getGroup(String groupName) throws GroupNotFoundException, AccessControlException, IOException {
        URL groupsURL = this.lookupServiceURL(Standards.GMS_GROUPS_01);
        URL getGroupURL = new URL(groupsURL.toExternalForm() + "/" + groupName);
        log.debug((Object)("getGroup request to " + getGroupURL.toString()));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        HttpDownload transfer = new HttpDownload(getGroupURL, (OutputStream)out);
        transfer.run();
        Throwable error = transfer.getThrowable();
        if (error != null) {
            log.debug((Object)("getGroup throwable (" + transfer.getResponseCode() + ")"), error);
            if (transfer.getResponseCode() == -1 || transfer.getResponseCode() == 401 || transfer.getResponseCode() == 403) {
                throw new AccessControlException(error.getMessage());
            }
            if (transfer.getResponseCode() == 400) {
                throw new IllegalArgumentException(error.getMessage());
            }
            if (transfer.getResponseCode() == 404) {
                throw new GroupNotFoundException(error.getMessage());
            }
            throw new IOException(error);
        }
        try {
            String groupXML = new String(out.toByteArray(), "UTF-8");
            log.debug((Object)("getGroup returned: " + groupXML));
            GroupReader groupReader = new GroupReader();
            return groupReader.read(groupXML);
        }
        catch (Exception bug) {
            log.error((Object)"Unexpected exception", (Throwable)bug);
            throw new RuntimeException(bug);
        }
    }

    public List<String> getGroupNames() throws AccessControlException, IOException {
        URL getGroupNamesURL = this.lookupServiceURL(Standards.GMS_GROUPS_01);
        log.debug((Object)("getGroupNames request to " + getGroupNamesURL.toString()));
        final ArrayList<String> groupNames = new ArrayList<String>();
        HttpDownload httpDownload = new HttpDownload(getGroupNamesURL, new InputStreamWrapper(){

            public void read(InputStream inputStream) throws IOException {
                try {
                    String line;
                    InputStreamReader inReader = new InputStreamReader(inputStream);
                    BufferedReader reader = new BufferedReader(inReader);
                    while ((line = reader.readLine()) != null) {
                        groupNames.add(line);
                    }
                }
                catch (Exception bug) {
                    log.error((Object)"Unexpected exception", (Throwable)bug);
                    throw new RuntimeException(bug);
                }
            }
        });
        httpDownload.setRetry(0, 0, HttpTransfer.RetryReason.NONE);
        httpDownload.run();
        Throwable error = httpDownload.getThrowable();
        if (error != null) {
            String errMessage = error.getMessage();
            int responseCode = httpDownload.getResponseCode();
            log.debug((Object)("getGroupNames response " + responseCode + ": " + errMessage));
            if (responseCode == 401 || responseCode == 403 || responseCode == -1) {
                throw new AccessControlException(errMessage);
            }
            if (responseCode == 400) {
                throw new IllegalArgumentException(errMessage);
            }
            throw new IOException("HttpResponse (" + responseCode + ") - " + errMessage);
        }
        log.debug((Object)("Content-Length: " + httpDownload.getContentLength()));
        log.debug((Object)("Content-Type: " + httpDownload.getContentType()));
        return groupNames;
    }

    public Group updateGroup(Group group) throws IllegalArgumentException, GroupNotFoundException, UserNotFoundException, AccessControlException, WriterException, IOException, ReaderException, URISyntaxException {
        URL groupsURL = this.lookupServiceURL(Standards.GMS_GROUPS_01);
        URL updateGroupURL = new URL(groupsURL.toExternalForm() + "/" + group.getID().getName());
        log.debug((Object)("updateGroup request to " + updateGroupURL.toString()));
        this.clearCache();
        StringBuilder groupXML = new StringBuilder();
        GroupWriter groupWriter = new GroupWriter();
        groupWriter.write(group, groupXML);
        log.debug((Object)("updateGroup: " + groupXML));
        HttpPost transfer = new HttpPost(updateGroupURL, new FileContent(groupXML.toString(), "application/xml", Charset.forName("UTF-8")), false);
        transfer.setTransferListener((TransferListener)this);
        transfer.run();
        Throwable error = transfer.getThrowable();
        if (error != null) {
            if (transfer.getResponseCode() == -1 || transfer.getResponseCode() == 401 || transfer.getResponseCode() == 403) {
                throw new AccessControlException(error.getMessage());
            }
            if (transfer.getResponseCode() == 400) {
                throw new IllegalArgumentException(error.getMessage());
            }
            if (transfer.getResponseCode() == 404) {
                if (error.getMessage() != null && error.getMessage().toLowerCase().contains("user")) {
                    throw new UserNotFoundException(error.getMessage());
                }
                throw new GroupNotFoundException(error.getMessage());
            }
            throw new IOException(error);
        }
        return new GroupReader().read(transfer.getResponseBody());
    }

    public void deleteGroup(String groupName) throws GroupNotFoundException, AccessControlException, IOException {
        URL groupsURL = this.lookupServiceURL(Standards.GMS_GROUPS_01);
        URL deleteGroupURL = new URL(groupsURL.toExternalForm() + "/" + groupName);
        log.debug((Object)("deleteGroup request to " + deleteGroupURL.toString()));
        this.clearCache();
        HttpDelete delete = new HttpDelete(deleteGroupURL, true);
        delete.run();
        Throwable error = delete.getThrowable();
        if (error != null) {
            if (error instanceof AccessControlException) {
                throw new AccessControlException(error.getMessage());
            }
            if (delete.getResponseCode() == 400) {
                throw new IllegalArgumentException(error.getMessage());
            }
            if (error instanceof ResourceNotFoundException) {
                throw new GroupNotFoundException(error.getMessage());
            }
            throw new IOException(error);
        }
    }

    public void addGroupMember(String targetGroupName, String groupMemberName) throws IllegalArgumentException, GroupNotFoundException, AccessControlException, IOException {
        String path = "/" + targetGroupName + "/groupMembers/" + groupMemberName;
        URL groupsURL = this.lookupServiceURL(Standards.GMS_GROUPS_01);
        URL addGroupMemberURL = new URL(groupsURL.toExternalForm() + path);
        log.debug((Object)("addGroupMember request to " + addGroupMemberURL.toString()));
        this.clearCache();
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[0]);
        HttpUpload httpUpload = new HttpUpload((InputStream)is, addGroupMemberURL);
        httpUpload.run();
        Throwable error = httpUpload.getThrowable();
        if (error != null) {
            int responseCode = httpUpload.getResponseCode();
            String errMessage = error.getMessage();
            if (responseCode == -1 || responseCode == 401 || responseCode == 403) {
                throw new AccessControlException(errMessage);
            }
            if (responseCode == 400) {
                throw new IllegalArgumentException(errMessage);
            }
            if (responseCode == 404) {
                throw new GroupNotFoundException(errMessage);
            }
            throw new IOException(errMessage);
        }
    }

    public void addUserMember(String targetGroupName, Principal userID) throws GroupNotFoundException, UserNotFoundException, AccessControlException, IOException {
        if (targetGroupName == null) {
            throw new IllegalArgumentException("targetGroupName required");
        }
        if (userID == null) {
            throw new IllegalArgumentException("userID required");
        }
        log.debug((Object)("addUserMember: " + targetGroupName + " + " + userID.getName()));
        String userIDType = AuthenticationUtil.getPrincipalType((Principal)userID);
        String path = "/" + targetGroupName + "/userMembers/" + NetUtil.encode((String)userID.getName()) + "?idType=" + userIDType;
        URL groupsURL = this.lookupServiceURL(Standards.GMS_GROUPS_01);
        URL addUserMemberURL = new URL(groupsURL.toExternalForm() + path);
        log.debug((Object)("addUserMember request to " + addUserMemberURL.toString()));
        this.clearCache();
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[0]);
        HttpUpload httpUpload = new HttpUpload((InputStream)is, addUserMemberURL);
        httpUpload.run();
        Throwable error = httpUpload.getThrowable();
        if (error != null) {
            int responseCode = httpUpload.getResponseCode();
            String errMessage = error.getMessage();
            if (responseCode == -1 || responseCode == 401 || responseCode == 403) {
                throw new AccessControlException(errMessage);
            }
            if (responseCode == 400) {
                throw new IllegalArgumentException(errMessage);
            }
            if (responseCode == 404) {
                if (errMessage != null && errMessage.toLowerCase().contains("user")) {
                    throw new UserNotFoundException(errMessage);
                }
                throw new GroupNotFoundException(errMessage);
            }
            throw new IOException(errMessage);
        }
    }

    public void removeGroupMember(String targetGroupName, String groupMemberName) throws GroupNotFoundException, AccessControlException, IOException {
        String path = "/" + targetGroupName + "/groupMembers/" + groupMemberName;
        URL groupsURL = this.lookupServiceURL(Standards.GMS_GROUPS_01);
        URL removeGroupMemberURL = new URL(groupsURL.toExternalForm() + path);
        log.debug((Object)("removeGroupMember request to " + removeGroupMemberURL.toString()));
        this.clearCache();
        HttpDelete delete = new HttpDelete(removeGroupMemberURL, true);
        delete.run();
        Throwable error = delete.getThrowable();
        if (error != null) {
            if (error instanceof AccessControlException) {
                throw (AccessControlException)error;
            }
            if (delete.getResponseCode() == 400) {
                throw new IllegalArgumentException(error.getMessage());
            }
            if (error instanceof ResourceNotFoundException) {
                throw new GroupNotFoundException(error.getMessage());
            }
            throw new IOException(error);
        }
    }

    public void removeUserMember(String targetGroupName, Principal userID) throws GroupNotFoundException, UserNotFoundException, AccessControlException, IOException {
        String userIDType = AuthenticationUtil.getPrincipalType((Principal)userID);
        log.debug((Object)("removeUserMember: " + targetGroupName + " - " + userID.getName() + " type: " + userIDType));
        String path = "/" + targetGroupName + "/userMembers/" + NetUtil.encode((String)userID.getName()) + "?idType=" + userIDType;
        URL groupsURL = this.lookupServiceURL(Standards.GMS_GROUPS_01);
        URL removeUserMemberURL = new URL(groupsURL.toExternalForm() + path);
        log.debug((Object)("removeUserMember: " + removeUserMemberURL.toString()));
        this.clearCache();
        HttpDelete delete = new HttpDelete(removeUserMemberURL, true);
        delete.run();
        Throwable error = delete.getThrowable();
        if (error != null) {
            if (error instanceof AccessControlException) {
                throw new AccessControlException(error.getMessage());
            }
            if (delete.getResponseCode() == 400) {
                throw new IllegalArgumentException(error.getMessage());
            }
            if (error instanceof ResourceNotFoundException) {
                String errMessage = error.getMessage();
                if (errMessage != null && errMessage.toLowerCase().contains("user")) {
                    throw new UserNotFoundException(errMessage);
                }
                throw new GroupNotFoundException(errMessage);
            }
            throw new IOException(error);
        }
    }

    private Principal getCurrentUserID() {
        Subject cur = AuthenticationUtil.getCurrentSubject();
        if (cur == null) {
            return null;
        }
        Set<HttpPrincipal> ps = cur.getPrincipals(HttpPrincipal.class);
        if (ps.isEmpty()) {
            return null;
        }
        Principal p = (Principal)ps.iterator().next();
        log.debug((Object)("getCurrentID: " + p.getClass()));
        return p;
    }

    public List<Group> getMemberships(Role role) throws UserNotFoundException, AccessControlException, IOException {
        return this.getMemberships(null, role);
    }

    private List<Group> getMemberships(Principal ignore, Role role) throws UserNotFoundException, AccessControlException, IOException {
        List<Group> cachedGroups;
        if (role == null) {
            throw new IllegalArgumentException("role are required.");
        }
        Principal userID = this.getCurrentUserID();
        if (userID != null && (cachedGroups = this.getCachedGroups(userID, role, true)) != null) {
            return cachedGroups;
        }
        String roleString = role.getValue();
        URL searchURL = this.lookupServiceURL(Standards.GMS_SEARCH_01);
        URL getMembershipsURL = new URL(searchURL.toExternalForm() + "?ROLE=" + NetUtil.encode((String)roleString));
        log.debug((Object)("getMemberships request to " + getMembershipsURL.toString()));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        HttpDownload transfer = new HttpDownload(getMembershipsURL, (OutputStream)out);
        transfer.run();
        Throwable error = transfer.getThrowable();
        if (error != null) {
            log.debug((Object)"getMemberships throwable", error);
            if (transfer.getResponseCode() == -1 || transfer.getResponseCode() == 401 || transfer.getResponseCode() == 403) {
                throw new AccessControlException(error.getMessage());
            }
            if (transfer.getResponseCode() == 404) {
                throw new UserNotFoundException(error.getMessage());
            }
            if (transfer.getResponseCode() == 400) {
                throw new IllegalArgumentException(error.getMessage());
            }
            throw new IOException(error);
        }
        try {
            String groupsXML = new String(out.toByteArray(), "UTF-8");
            log.debug((Object)("getMemberships returned: " + groupsXML));
            GroupListReader groupListReader = new GroupListReader();
            List<Group> groups = groupListReader.read(groupsXML);
            this.setCachedGroups(userID, groups, role);
            return groups;
        }
        catch (Exception bug) {
            log.error((Object)"Unexpected exception", (Throwable)bug);
            throw new RuntimeException(bug);
        }
    }

    public Group getMembership(String groupName) throws UserNotFoundException, AccessControlException, IOException {
        return this.getMembership(groupName, Role.MEMBER);
    }

    public Group getMembership(String groupName, Role role) throws UserNotFoundException, AccessControlException, IOException {
        Group cachedGroup;
        if (groupName == null || role == null) {
            throw new IllegalArgumentException("groupName and role are required.");
        }
        Principal userID = this.getCurrentUserID();
        if (userID != null && (cachedGroup = this.getCachedGroup(userID, groupName, role)) != null) {
            return cachedGroup;
        }
        String roleString = role.getValue();
        String searchGroupPath = "?ROLE=" + NetUtil.encode((String)roleString) + "&GROUPID=" + NetUtil.encode((String)groupName);
        URL searchURL = this.lookupServiceURL(Standards.GMS_SEARCH_01);
        URL getMembershipURL = new URL(searchURL.toExternalForm() + searchGroupPath);
        log.debug((Object)("getMembership request to " + getMembershipURL.toString()));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        HttpDownload transfer = new HttpDownload(getMembershipURL, (OutputStream)out);
        transfer.run();
        Throwable error = transfer.getThrowable();
        if (error != null) {
            log.debug((Object)"getMembership throwable", error);
            if (transfer.getResponseCode() == -1 || transfer.getResponseCode() == 401 || transfer.getResponseCode() == 403) {
                throw new AccessControlException(error.getMessage());
            }
            if (transfer.getResponseCode() == 404) {
                throw new UserNotFoundException(error.getMessage());
            }
            if (transfer.getResponseCode() == 400) {
                throw new IllegalArgumentException(error.getMessage());
            }
            throw new IOException(error);
        }
        try {
            String groupsXML = new String(out.toByteArray(), "UTF-8");
            log.debug((Object)("getMembership returned: " + groupsXML));
            GroupListReader groupListReader = new GroupListReader();
            List<Group> groups = groupListReader.read(groupsXML);
            if (groups.isEmpty()) {
                return null;
            }
            if (groups.size() == 1) {
                Group ret = groups.get(0);
                this.addCachedGroup(userID, ret, role);
                return ret;
            }
            throw new IllegalStateException("Duplicate membership for " + userID + " in group " + groupName);
        }
        catch (Exception bug) {
            log.error((Object)"Unexpected exception", (Throwable)bug);
            throw new RuntimeException(bug);
        }
    }

    public boolean isMember(String groupName) throws UserNotFoundException, AccessControlException, IOException {
        return this.isMember(groupName, Role.MEMBER);
    }

    public boolean isMember(String groupName, Role role) throws UserNotFoundException, AccessControlException, IOException {
        return this.isMember(this.getCurrentUserID(), groupName, role);
    }

    private boolean isMember(Principal userID, String groupName, Role role) throws UserNotFoundException, AccessControlException, IOException {
        Group group = this.getMembership(groupName, role);
        return group != null;
    }

    protected void clearCache() {
        AccessControlContext acContext = AccessController.getContext();
        Subject subject = Subject.getSubject(acContext);
        if (subject != null) {
            subject.getPrivateCredentials().remove(new GroupMemberships());
        }
    }

    protected GroupMemberships getGroupCache(Principal userID) {
        AccessControlContext acContext = AccessController.getContext();
        Subject subject = Subject.getSubject(acContext);
        if (this.userIsSubject(userID, subject)) {
            Set<GroupMemberships> gset = subject.getPrivateCredentials(GroupMemberships.class);
            if (gset == null || gset.isEmpty()) {
                GroupMemberships mems = new GroupMemberships(this.serviceID.toString(), userID);
                subject.getPrivateCredentials().add(mems);
                return mems;
            }
            GroupMemberships mems = gset.iterator().next();
            if (!this.serviceID.toString().equals(mems.getServiceURI())) {
                log.debug((Object)("Not using cache because of differing service URIs: [" + this.serviceID.toString() + "][" + mems.getServiceURI() + "]"));
                return null;
            }
            return mems;
        }
        return null;
    }

    protected Group getCachedGroup(Principal userID, String groupID, Role role) {
        List<Group> groups = this.getCachedGroups(userID, role, false);
        if (groups == null) {
            return null;
        }
        for (Group g : groups) {
            if (!g.getID().getName().equals(groupID)) continue;
            return g;
        }
        return null;
    }

    protected List<Group> getCachedGroups(Principal userID, Role role, boolean complete) {
        GroupMemberships mems = this.getGroupCache(userID);
        if (mems == null) {
            return null;
        }
        Boolean cacheState = mems.isComplete(role);
        if (!complete || Boolean.TRUE.equals(cacheState)) {
            return mems.getMemberships(role);
        }
        return null;
    }

    protected void addCachedGroup(Principal userID, Group group, Role role) {
        GroupMemberships mems = this.getGroupCache(userID);
        if (mems == null) {
            return;
        }
        mems.add(group, role);
    }

    protected void setCachedGroups(Principal userID, List<Group> groups, Role role) {
        GroupMemberships mems = this.getGroupCache(userID);
        if (mems == null) {
            return;
        }
        mems.add(groups, role);
    }

    protected boolean userIsSubject(Principal userID, Subject subject) {
        if (userID == null || subject == null) {
            return false;
        }
        for (Principal subjectPrincipal : subject.getPrincipals()) {
            if (!AuthenticationUtil.equals((Principal)subjectPrincipal, (Principal)userID)) continue;
            return true;
        }
        return false;
    }

    protected RegistryClient getRegistryClient() {
        return new RegistryClient();
    }

    private URL lookupServiceURL(URI standard) throws AccessControlException {
        Subject subject = AuthenticationUtil.getCurrentSubject();
        AuthMethod am = AuthenticationUtil.getAuthMethodFromCredentials((Subject)subject);
        if (am == null || am.equals((Object)AuthMethod.ANON)) {
            throw new AccessControlException("Anonymous access not supported.");
        }
        URL serviceURL = this.getRegistryClient().getServiceURL(this.serviceID, standard, am);
        if (serviceURL == null) {
            throw new RuntimeException(String.format("Unable to get Service URL for '%s', '%s', '%s'", this.serviceID.toString(), standard, am));
        }
        return serviceURL;
    }
}

