/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.ac;

import ca.nrc.cadc.ac.InternalID;
import ca.nrc.cadc.ac.PersonalDetails;
import ca.nrc.cadc.ac.PosixDetails;
import ca.nrc.cadc.auth.HttpPrincipal;
import ca.nrc.cadc.auth.PrincipalComparator;
import java.security.Principal;
import java.util.Comparator;
import java.util.Date;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.security.auth.x500.X500Principal;

public class User {
    private InternalID id;
    private SortedSet<Principal> identities;
    public PersonalDetails personalDetails;
    public PosixDetails posixDetails;
    public Date lastModified;
    public Object appData;

    public User() {
        PrincipalComparator p = new PrincipalComparator();
        UserPrincipalComparator u = new UserPrincipalComparator(p);
        this.identities = new TreeSet<Principal>(Comparator.nullsLast(u));
    }

    public InternalID getID() {
        return this.id;
    }

    public Set<Principal> getIdentities() {
        return this.identities;
    }

    public <S extends Principal> Set<S> getIdentities(Class<S> identityClass) {
        PrincipalComparator p = new PrincipalComparator();
        UserPrincipalComparator u = new UserPrincipalComparator(p);
        TreeSet<Principal> matchedIdentities = new TreeSet<Principal>(u);
        for (Principal principal : this.identities) {
            if (!identityClass.isAssignableFrom(principal.getClass())) continue;
            matchedIdentities.add(principal);
        }
        return matchedIdentities;
    }

    public HttpPrincipal getHttpPrincipal() {
        Set<HttpPrincipal> identities = this.getIdentities(HttpPrincipal.class);
        if (!identities.isEmpty()) {
            return identities.iterator().next();
        }
        return null;
    }

    public X500Principal getX500Principal() {
        Set<X500Principal> identities = this.getIdentities(X500Principal.class);
        if (!identities.isEmpty()) {
            return identities.iterator().next();
        }
        return null;
    }

    public boolean isConsistent(User superset) {
        if (superset == null) {
            return false;
        }
        if (this.identities.size() == 0 || superset.identities.size() == 0) {
            return false;
        }
        PrincipalComparator p = new PrincipalComparator();
        TreeSet<Principal> set1 = new TreeSet<Principal>((Comparator<Principal>)p);
        TreeSet<Principal> set2 = new TreeSet<Principal>((Comparator<Principal>)p);
        set1.addAll(superset.getIdentities());
        set2.addAll(this.getIdentities());
        return set1.containsAll(set2);
    }

    public boolean equals(Object obj) {
        if (obj instanceof User) {
            User user = (User)obj;
            return this.isConsistent(user) || user.isConsistent(this);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        if (this.id != null) {
            sb.append(this.id);
        }
        sb.append("]");
        return sb.toString();
    }

    public String toPrettyString() {
        HttpPrincipal p1 = this.getHttpPrincipal();
        if (p1 != null) {
            return p1.getName();
        }
        X500Principal p2 = this.getX500Principal();
        if (p2 != null) {
            return p2.getName();
        }
        return this.toString();
    }

    private class UserPrincipalComparator
    implements Comparator<Principal> {
        private PrincipalComparator p;

        UserPrincipalComparator(PrincipalComparator p) {
            this.p = p;
        }

        @Override
        public int compare(Principal o1, Principal o2) {
            if (o1 == null || o2 == null) {
                throw new IllegalArgumentException("Cannot compare null objects");
            }
            if (o1 instanceof HttpPrincipal && o2 instanceof HttpPrincipal) {
                return 0;
            }
            return this.p.compare(o1, o2);
        }
    }
}

