/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.ac;

import java.net.URI;
import java.util.UUID;

public class InternalID {
    private URI uri;
    private UUID uuid;

    public InternalID(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri is null");
        }
        if (uri.getFragment() != null) {
            throw new IllegalArgumentException("fragment not allowed");
        }
        this.uri = uri;
        this.uuid = UUID.fromString(uri.getQuery());
    }

    public InternalID(URI uri, UUID id) {
        if (uri == null) {
            throw new IllegalArgumentException("uri is null");
        }
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        if (uri.getQuery() != null) {
            throw new IllegalArgumentException("query not allowed in base uri");
        }
        if (uri.getFragment() != null) {
            throw new IllegalArgumentException("fragment not allowed");
        }
        this.uri = URI.create(uri.toASCIIString() + "?" + id.toString());
        this.uuid = id;
    }

    public URI getURI() {
        return this.uri;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.uri.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InternalID)) {
            return false;
        }
        InternalID other = (InternalID)obj;
        return this.uri.equals(other.uri);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.uri + "]";
    }
}

